package jp.ac.titech.sharp4k.cuten;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.view.View;

public abstract class BaseApp {
	private ResultSender sender;
	private CloseRequester requester;

	/* package */void setSender(ResultSender sender) {
		this.sender = sender;
	}

	/* package */void setCloseRequester(CloseRequester requester) {
		this.requester = requester;
	}

	protected void sendResult(int[] results) {
		sender.send(results);
	}

	abstract protected View createView(Context ctx, Resources res);

	protected void onClose() {
	}

	protected void close() {
		requester.close();
	}

	protected void onConfigurationChanged(Configuration newConfiguration) {
	}

	protected void onPause() {
	}

	protected void onResume() {
	}
}
