package jp.ac.titech.sharp4k.cuten.test;

import java.io.IOException;
import java.util.List;

import jp.ac.titech.sharp4k.cuten.Apk;
import jp.ac.titech.sharp4k.cuten.Lecture;
import jp.ac.titech.sharp4k.cuten.Task;
import jp.ac.titech.sharp4k.cuten.Teacher;

import android.util.JsonWriter;

public class ToJSON {
	public static void write(JsonWriter w, Lecture l, List<Apk> apks)
			throws IOException {
		w.beginObject();
		w.name("id").value(l.getId());
		w.name("name").value(l.getName());

		w.name("tasks");
		w.beginArray();
		for (Apk apk : apks) {
			Task t = apk.getTask();
			w.beginObject();
			w.name("id").value(t.getId());
			w.name("name").value(t.getName());

			w.name("apk");
			w.beginObject();
			w.name("id").value(apk.getId());
			w.name("revision").value(apk.getRevision());
			w.name("name").value(apk.getClassName());
			w.endObject();

			w.endObject();
		}
		w.endArray();

		Teacher teacher = l.getTeacher();
		w.name("teacher");
		w.beginObject();
		w.name("id").value(teacher.getId());
		w.name("name").value(teacher.getName());
		w.endObject();

		w.endObject();
	}
}