class UsersController < ApplicationController
  before_filter :authenticate_user!

  def profile
    respond_to do |format|
      format.html
      format.json do
        render :json => current_user.as_json(:only => [:email, :student_number])
      end
    end
  end

  def reset_token
    respond_to do |format|
      format.json do
        current_user.reset_authentication_token!
        render :json => { :auth_token => current_user.authentication_token }
      end
    end
  end
end
