require 'test_helper'

class LecturesControllerTest < ActionController::TestCase
  include Devise::TestHelpers

  setup do
    @apk_old = FactoryGirl.create :apk
    @apk = FactoryGirl.create :apk, :task => @apk_old.task
    @lecture = @apk.task.lecture
    @teacher = @lecture.teacher
  end

  test "should get index with JSON" do
    get :index, :format => :json
    assert_response :success
    assert_not_nil assigns(:lectures)
  end

  test "non-teacher should not get new" do
    user = FactoryGirl.create :user
    sign_in user

    get :new
    assert_redirected_to root_path
  end

  test "teacher should get new" do
    sign_in @teacher

    get :new
    assert_response :success
    assert_not_nil assigns(:lecture)
  end

  test "non-teacher should not create lecture" do
    user = FactoryGirl.create :user
    sign_in user

    post :create, :lecture => { :name => @lecture.name }
    assert_redirected_to root_path
  end

  test "teacher should create lecture" do
    sign_in @teacher

    assert_difference('Lecture.count') do
      post :create, :lecture => { :name => @lecture.name }
    end
    lecture = assigns :lecture
    assert_not_nil lecture
    assert_equal @teacher.id, lecture.teacher.id
  end

  test "should show lecture" do
    get :show, id: @lecture
    assert_response :success
  end

  test "should NOT update lecture" do
    assert_no_routes do
      put :update, id: @lecture, lecture: { name: @lecture.name }
    end
  end

  test "should NOT destroy lecture" do
    assert_no_routes do
      delete :destroy, id: @lecture
    end
  end

  test "should NOT return tasks without ids" do
    get :index, :format => :json
    assert_response :success
    lecs = JSON.parse @response.body
    lecs.each do |lec|
      assert !lec.has_key?('tasks')
    end
  end

  test "should return tasks with ids" do
    get :index, :ids => [@lecture], :format => :json
    assert_response :success
    lecs = JSON.parse @response.body
    assert_equal lecs.size, 1
    assert lecs[0].has_key?('tasks')

    tasks = lecs[0]['tasks']
    assert_equal 1, tasks.size
    assert tasks[0].has_key?('apk')

    apk = tasks[0]['apk']
    assert apk.has_key?('id')
    assert_not_equal @apk_old.id, apk['id']
    assert_equal @apk.id, apk['id']
  end
end
