require 'test_helper'

class GetProfileJsonTest < ActionDispatch::IntegrationTest
  setup do
    @user = FactoryGirl.create :user
    @auth_token = @user.authentication_token
  end

  test 'cannot get profile without auth_token' do
    get '/users/profile.json'
    assert_response 401
    j = JSON.parse @response.body
    assert j.has_key?('error')
  end

  test 'cannot get profile with wrong auth_token' do
    get '/users/profile.json', :auth_token => @auth_token.swapcase
    assert_response 401
    j = JSON.parse @response.body
    assert j.has_key?('error')
  end

  test 'login and get profile with auth_token' do
    get '/users/profile.json', :auth_token => @auth_token
    assert_response :success
    j = JSON.parse @response.body
    assert_equal j['email'], @user.email
  end
end
