/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import roboguice.inject.InjectResource;
import roboguice.inject.Nullable;

public class ResourceListener
implements TypeListener {
    protected Application application;

    public ResourceListener(Application application) {
        this.application = application;
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(InjectResource.class) || Modifier.isStatic(field.getModifiers())) continue;
                typeEncounter.register(new ResourceMembersInjector(field, this.application, field.getAnnotation(InjectResource.class)));
            }
        }
    }

    public void requestStaticInjection(Class<?> ... types) {
        Class<?>[] arr$ = types;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Class<?> c = arr$[i$]; c != Object.class; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(InjectResource.class)) continue;
                    new ResourceMembersInjector<Object>(field, this.application, field.getAnnotation(InjectResource.class)).injectMembers(null);
                }
            }
        }
    }

    protected static class ResourceMembersInjector<T>
    implements MembersInjector<T> {
        protected Field field;
        protected Application application;
        protected InjectResource annotation;

        public ResourceMembersInjector(Field field, Application application, InjectResource annotation) {
            this.field = field;
            this.application = application;
            this.annotation = annotation;
        }

        public void injectMembers(T instance) {
            Animation value = null;
            try {
                Resources resources = this.application.getResources();
                int id = this.getId(resources, this.annotation);
                Class<?> t = this.field.getType();
                if (String.class.isAssignableFrom(t)) {
                    value = resources.getString(id);
                } else if (Boolean.TYPE.isAssignableFrom(t) || Boolean.class.isAssignableFrom(t)) {
                    value = Boolean.valueOf(resources.getBoolean(id));
                } else if (ColorStateList.class.isAssignableFrom(t)) {
                    value = resources.getColorStateList(id);
                } else if (Integer.TYPE.isAssignableFrom(t) || Integer.class.isAssignableFrom(t)) {
                    value = Integer.valueOf(resources.getInteger(id));
                } else if (Drawable.class.isAssignableFrom(t)) {
                    value = resources.getDrawable(id);
                } else if (String[].class.isAssignableFrom(t)) {
                    value = resources.getStringArray(id);
                } else if (int[].class.isAssignableFrom(t) || Integer[].class.isAssignableFrom(t)) {
                    value = (Animation)resources.getIntArray(id);
                } else if (Animation.class.isAssignableFrom(t)) {
                    value = AnimationUtils.loadAnimation((Context)this.application, (int)id);
                } else if (Movie.class.isAssignableFrom(t)) {
                    value = resources.getMovie(id);
                }
                if (value == null && Nullable.notNullable(this.field)) {
                    throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
                }
                this.field.setAccessible(true);
                this.field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException f) {
                throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", value != null ? value.getClass() : "(null)", value, this.field.getType(), this.field.getName()));
            }
        }

        protected int getId(Resources resources, InjectResource annotation) {
            int id = annotation.value();
            return id >= 0 ? id : resources.getIdentifier(annotation.name(), null, null);
        }
    }
}

