class Task < ActiveRecord::Base
  belongs_to :lecture
  has_one :apk, :autosave => true
  attr_accessible :name

  validates_presence_of :lecture, :name

  include JsonWithoutTimestamps
  def as_json(options = {})
    super options.merge({:methods => [:apk], :except => [:lecture_id]})
  end

  def achievement(user)
    Achievement.find_by_task_id_and_user_id!(self.id, user.id)
  end
end
