class Teacher < ActiveRecord::Base
  # Include default devise modules. Others available are:
  # :token_authenticatable, :confirmable,
  # :lockable, :timeoutable and :omniauthable
  devise :database_authenticatable, :registerable,
         :recoverable, :rememberable, :trackable, :validatable

  # Setup accessible (or protected) attributes for your model
  attr_accessible :email, :password, :password_confirmation, :remember_me

  has_many :lectures
  attr_accessible :name

  validates_presence_of :name

  attr_accessible :icon, :icon_file_name
  has_attached_file :icon,
    :url => ':env_prefix/:attachment/:sha1.:extension',
    :use_timestamp => false

  include JsonWithoutTimestamps
  def as_json(options = {})
    icon_keys = [:icon_file_name, :icon_file_size, :icon_content_type, :icon_updated_at]
    j = super options.merge({:except => (options[:except] || []) + icon_keys})
    j['icon_path'] = icon.exists? ? icon.url : nil
    j
  end
end
