require 'test_helper'

class HomeControllerTest < ActionController::TestCase
  include Devise::TestHelpers

  test "should get index" do
    get :index
    assert_response :success
  end

  test "user should get profile after sign-in" do
    user = FactoryGirl.create :user
    sign_in user

    get :index
    assert_response :success
    assert_match user.email, @response.body
    assert_match user.authentication_token, @response.body
  end

  test "teacher should get his lectures after sign-in" do
    lecture = FactoryGirl.create :lecture
    teacher = lecture.teacher
    sign_in teacher

    get :index
    assert_response :success
    assert_match lecture.name, @response.body
  end

  test "teacher should show icon if the teacher has icon" do
    teacher = FactoryGirl.create :teacher
    sign_in teacher

    get :index
    assert_response :success
    imgs = assert_select '.icon', 1
    assert_equal teacher.icon.url, imgs[0]['src']
  end

  test "teacher should not show icon if the teacher has no icon" do
    teacher = FactoryGirl.create :teacher, :icon => nil
    sign_in teacher

    get :index
    assert_response :success
    assert_select '.icon', 0
  end
end
