require 'test_helper'

class ApkTest < ActiveSupport::TestCase
  test 'save correct apk' do
    apk = FactoryGirl.build :apk
    assert apk.save
  end

  test 'reject wrong class name' do
    if not Rails.configuration.dexdump_path
      skip 'dexdump is not available'
    end
    apk = FactoryGirl.build :apk, :name => 'does.not.exist'
    assert !apk.save
    assert_not_empty apk.errors[:apk]
  end

  test 'reject invalid apk file' do
    if not Rails.configuration.dexdump_path
      skip 'dexdump is not available'
    end
    file = fixture_file_upload 'dummy.apk'
    apk = FactoryGirl.build :apk, :apk => file
    assert !apk.save
    assert_not_empty apk.errors[:apk]
  end

  test 'cannot change only class name' do
    apk = FactoryGirl.create :apk
    apk.name = apk.name.swapcase
    assert !apk.save
    assert_not_empty apk.errors[:name]
  end
end
