package jp.ac.titech.sharp4k.cuten.sampletask;

import java.util.HashSet;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.FontMetrics;
import android.graphics.Paint.Style;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;

public class MatrixView extends View {
	private Resources res;
	private float width, height;
	private int row, col, checkrow, checkcol;
	private HashSet<Pair<Integer, Integer>> cAnswer, uAnswer;
	private String[][] bits;
	private TypedArray question;

	public MatrixView(Context ctx, Resources res, int questionId) {
		super(ctx);
		setFocusable(true);
		setFocusableInTouchMode(true);
		this.res = res;
		question = res.obtainTypedArray(questionId);
		row = question.getInteger(0, -1);
		col = question.getInteger(1, -1);
		checkrow = question.getInteger(2, -1);
		checkcol = question.getInteger(3, -1);
		TypedArray code = res.obtainTypedArray(question.getResourceId(4, -1));
		bits = new String[code.length()][];
		for (int i = 0; i < code.length(); i++) {
			bits[i] = res.getStringArray(code.getResourceId(i, -1));
		}
		cAnswer = new HashSet<Pair<Integer, Integer>>();
		TypedArray answer = res.obtainTypedArray(question.getResourceId(5, -1));
		for (int i = 0; i < answer.length(); i++) {
			cAnswer.add(new Pair<Integer, Integer>(res.getIntArray(answer
					.getResourceId(i, -1))[0], res.getIntArray(answer
					.getResourceId(i, -1))[1]));
		}
		uAnswer = new HashSet<Pair<Integer, Integer>>();
	}

	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		width = w / (col + 2);
		height = h / (row + 2);
		super.onSizeChanged(w, h, oldw, oldh);
	}

	@Override
	protected void onDraw(Canvas canvas) {
		// draw matrix line
		Paint line = new Paint();
		line.setColor(Color.GRAY);
		for (int i = 1; i < row + 2; i++) {
			canvas.drawLine(width, i * height, width * (col + 1), i * height,
					line);
		}
		for (int i = 1; i < col + 2; i++) {
			canvas.drawLine(i * width, height, i * width, height * (row + 1),
					line);
		}

		// draw checksum line
		Paint cline = new Paint();
		cline.setColor(Color.RED);
		canvas.drawLine(width, checkrow * height, width * (col + 1), checkrow
				* height, cline);
		canvas.drawLine(width, (checkrow + 1) * height, width * (col + 1),
				(checkrow + 1) * height, cline);
		canvas.drawLine(width, checkrow * height, width, (checkrow + 1)
				* height, cline);
		canvas.drawLine(width * (col + 1), checkrow * height,
				width * (col + 1), (checkrow + 1) * height, cline);
		canvas.drawLine(checkcol * width, height, checkcol * width, (row + 1)
				* height, cline);
		canvas.drawLine((checkcol + 1) * width, height, (checkcol + 1) * width,
				(row + 1) * height, cline);
		canvas.drawLine(checkcol * width, height, (checkcol + 1) * width,
				height, cline);
		canvas.drawLine(checkcol * width, (row + 1) * height, (checkcol + 1)
				* width, (row + 1) * height, cline);

		// selRects
		Paint selected = new Paint();
		selected.setARGB(50, 0, 255, 255);
		for (Pair<Integer, Integer> i : uAnswer) {
			canvas.drawRect(i.second * width, i.first * height, i.second
					* width + width, i.first * height + height, selected);
		}

		// bits
		Paint foreground = new Paint(Paint.ANTI_ALIAS_FLAG);
		foreground.setColor(Color.GRAY);
		foreground.setStyle(Style.FILL);
		foreground.setTextSize(height * 0.75f);
		foreground.setTextScaleX(width / height);
		foreground.setTextAlign(Paint.Align.CENTER);
		FontMetrics fm = foreground.getFontMetrics();
		float x = width / 2;
		float y = height / 2 - (fm.ascent + fm.descent) / 2;
		for (int i = 1; i < row + 1; i++) {
			for (int j = 1; j < col + 1; j++) {
				canvas.drawText(bits[i - 1][j - 1], j * width + x, i * height
						+ y, foreground);
			}
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		if (event.getAction() != MotionEvent.ACTION_DOWN) {
			return super.onTouchEvent(event);
		} else {
			// position
			int selX, selY;
			selX = (int) (event.getX() / width);
			selY = (int) (event.getY() / height);
			if (selX <= 0 || selY <= 0 || selX > col || selY > row
					|| selX == checkcol || selY == checkrow) {
				return true;
			}
			// add user answer and inverse bit
			Pair<Integer, Integer> tmpAns = new Pair<Integer, Integer>(selY,
					selX);
			if (!uAnswer.remove(tmpAns)) {
				uAnswer.add(tmpAns);
			}
			if (bits[selY - 1][selX - 1].equals("0")) {
				bits[selY - 1][selX - 1] = "1";
			} else {
				bits[selY - 1][selX - 1] = "0";
			}
			invalidate();
		}
		return true;
	}

	public void reset() {
		TypedArray code = res.obtainTypedArray(question.getResourceId(4, -1));
		bits = new String[code.length()][];
		for (int i = 0; i < code.length(); i++) {
			bits[i] = res.getStringArray(code.getResourceId(i, -1));
		}
		uAnswer = new HashSet<Pair<Integer, Integer>>();
		invalidate();
	}

	public int mark() {
		if (uAnswer.equals(cAnswer)) {
			return 100;
		} else {
			return 0;
		}
	}
}