package jp.ac.titech.sharp4k.cuten.sampletask;

import java.util.Timer;
import java.util.TimerTask;

import jp.ac.titech.sharp4k.cuten.BaseApp;
import jp.ac.titech.sharp4k.cuten.R;
import jp.ac.titech.sharp4k.cuten.sampletask.polychoron.GameRender;
import jp.ac.titech.sharp4k.cuten.sampletask.polychoron.GameSurfaceView;
import jp.ac.titech.sharp4k.cuten.sampletask.polychoron.PentachoronObj;
import jp.ac.titech.sharp4k.cuten.sampletask.polychoron.PolychoronObj;
import jp.ac.titech.sharp4k.cuten.sampletask.polychoron.ScreenInfo;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

public class PolychoronTask extends BaseApp {
	private static final String TAG = PolychoronTask.class.getSimpleName();
	private Context ctx;
	private Resources res;
	private GameSurfaceView view;
	private GameRender renderer;
	

	enum Problem {
		VERTEX_NUMBER, EDGE_NUMBER, PLANE_NUMBER
	};

	private static final Problem prob = Problem.PLANE_NUMBER;// 問題種類指定
	private static final int CHOICE_ID=R.array.penta_p_choice;
	private PolychoronObj obj = new PentachoronObj(0.5f);
	RadioGroup radioGroupChoice;
	Handler handler = new Handler();
	Timer timer;

	@Override
	protected View createView(Context ctx, Resources res) {
		this.ctx = ctx;
		this.res = res;
		//
		LinearLayout body = new LinearLayout(ctx);
		LinearLayout questionArea = new LinearLayout(ctx);
		body.setOrientation(LinearLayout.VERTICAL);
		questionArea.setOrientation(LinearLayout.VERTICAL);
		//
		view = new GameSurfaceView(ctx, obj);
		view.setEGLContextClientVersion(2); // GLES2 を指定
		ScreenInfo screen = new ScreenInfo();
		renderer = new GameRender(view, screen, obj);
		renderer.resouce = res;
		// ビット深度(RGB=5,6,5),ステンシルバッファ1
		// デバイスにより異なる可能性あり
		view.setEGLConfigChooser(5, 6, 5, 0, 0, 1);
		view.setRenderer(renderer);
		//
		String question;
		switch (prob) {
		case VERTEX_NUMBER:
			question = res.getString(R.string.first_vertex);
			break;
		case EDGE_NUMBER:
			question = res.getString(R.string.first_edge);
			break;
		case PLANE_NUMBER:
			question = res.getString(R.string.first_plane);
			break;
		default:
			question = "";
			Log.d(TAG, "no question error");
		}
		TextView text = new TextView(ctx);
		text.setText(question);
		questionArea.addView(text);

		radioGroupChoice = new RadioGroup(ctx);
		radioGroupChoice.setOrientation(LinearLayout.HORIZONTAL);

		int[] choice = res.getIntArray(CHOICE_ID);
		for (int i = 0; i < choice.length; i++) {
			RadioButton btn = new RadioButton(ctx);
			btn.setText(String.valueOf(choice[i]));
			btn.setId(choice[i]);
			radioGroupChoice.addView(btn);
		}
		questionArea.addView(radioGroupChoice);
		body.addView(questionArea);
		body.addView(view);
		//
		TimerTask task = new TimerTask() {
			@Override
			public void run() {
				handler.post(new Runnable() {
					public void run() {
						renderer.update();
					}
				});
			}
		};
		timer = new Timer(true);
		timer.schedule(task, 0, 16);//~60fps
		return body;
	}

	@Override
	protected void onClose() {
		timer.cancel();
		int n = radioGroupChoice.getCheckedRadioButtonId();
		int ans;
		switch (prob) {
		case VERTEX_NUMBER:
			ans = obj.getVertexNum();
			break;
		case EDGE_NUMBER:
			ans = obj.getEdgeNum()/2;
			break;
		case PLANE_NUMBER:
			ans = obj.getPlaneNum();
			break;
		default:
			ans = 0;
			Log.d(TAG, "no answer error");
		}
		int res = (ans == n) ? 100 : 0;
		int[] result = { res };
		sendResult(result);
		super.onClose();
	}
}
