package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;

public class GameSurfaceView extends GLSurfaceView {
	private ModelController controller;

	public GameSurfaceView(Context context, PolychoronObj obj) {
		super(context);
		controller = new ModelController(context, obj);
		gestureDetector = controller.gestureDetector;
		scaleDetector = controller.scaleDetector;
	}

	public GestureDetector gestureDetector;
	public ScaleGestureDetector scaleDetector;

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		if (!scaleDetector.onTouchEvent(event)) {// 続けないならば終わり
			return true;
		}
		gestureDetector.onTouchEvent(event);
		return true;
	}
}
