package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;

import android.content.Context;
import android.opengl.Matrix;
import android.util.Log;
import android.view.GestureDetector;
import android.view.GestureDetector.OnDoubleTapListener;
import android.view.GestureDetector.OnGestureListener;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;

//ユーザの操作による振る舞いを決定するクラス
public class ModelController implements OnDoubleTapListener, OnGestureListener,
		ScaleGestureDetector.OnScaleGestureListener {
	GestureDetector gestureDetector;
	ScaleGestureDetector scaleDetector;
	private PolychoronObj obj;
	Context ctx;
	// 単位行列
	private float[] uniM = new float[16];
	// スケール動作中の基準となる拡大率
	private float scale;
	// 回転動作中の回転行列
	private float[] rm = new float[16];
	private float scalingSensitivity=5.0f;
	public float rotSpeed=0.002f;
	private static final float THRESHOLD=1.0e-5f;
	
	public ModelController(Context context, PolychoronObj o) {
		obj = o;
		gestureDetector = new GestureDetector(context, this);
		scaleDetector = new ScaleGestureDetector(context, this);
		Matrix.setIdentityM(rm, 0);
		Matrix.setIdentityM(uniM, 0);
		ctx = context;
	}

	@Override
	public boolean onScale(ScaleGestureDetector detector) {
		double r = Math.exp(Math.log(detector.getScaleFactor()) / scalingSensitivity);
		Log.v("onScale", "scaleFactor = " + r);
		obj.setScale((float) (scale * r));
		return false;
	}

	@Override
	public boolean onScaleBegin(ScaleGestureDetector detector) {
		scale = obj.getScale();
		Log.v("onScale", "begin");
		return true;
	}

	@Override
	public void onScaleEnd(ScaleGestureDetector detector) {

	}

	@Override
	public boolean onDown(MotionEvent e) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
			float velocityY) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void onLongPress(MotionEvent e) {
		// TODO Auto-generated method stub

	}

	float[] temp = new float[16];	
	float[] rot = new float[16];	
	// スクロール動作で３次元物体を回転させる
	@Override
	public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
			float distanceY) {
		Log.v("onScroll", "x = " + String.valueOf(distanceX) + ", " + "y = "
				+ String.valueOf(distanceY));
		float d = (float) Math.sqrt(distanceX * distanceX + distanceY
				* distanceY);
		if(d>THRESHOLD){
			Matrix.setRotateM(temp, 0, d / 10, -distanceY, -distanceX, 0);
			Matrix.multiplyMM(rm, 0, temp, 0, rm, 0);
			obj.transpose3(rm);
		}
		return true;
	}

	@Override
	public void onShowPress(MotionEvent e) {
		// TODO Auto-generated method stub
	}

	@Override
	public boolean onSingleTapUp(MotionEvent e) {
		return false;
	}

	public enum ModeD4 {
		STOP, XU, YU, ZU
	};

	private ModeD4 mode = ModeD4.STOP;

	@Override
	public boolean onDoubleTap(MotionEvent e) {
		return false;
	}

	@Override
	public boolean onDoubleTapEvent(MotionEvent e) {
		return false;
	}

	@Override
	public boolean onSingleTapConfirmed(MotionEvent e) {
		if (mode==ModeD4.STOP) {
			PolychoronVertex.rotateUX(rot,rotSpeed);
			obj.transpose4u(rot);
			mode = ModeD4.ZU;
			obj.transpose4u(rot);
		}else{
			obj.transpose4u(uniM);
			mode = ModeD4.STOP;
		}
		return false;
	}

}
