#!/usr/bin/env perl
use strict;
use warnings;

use Encode qw/encode_utf8/;
use Encode::Guess qw/shiftjis/;

for my $arg (@ARGV) {
  my $rfh;
  unless (open $rfh, $arg) {
    print "$arg: failed to open for reading: $!\n";
    next;
  }
  binmode $rfh;
  my $data = do { local $/; <$rfh>; };
  close $rfh;
  my $decoder = Encode::Guess->guess($data);
  unless (ref $decoder) {
    print "$arg: cannot guess the encoding\n";
    next;
  }
  my $decoded = $decoder->decode($data);
  # remove BOM
  $decoded =~ s/\x{feff}//g;
  # convert CRLF to LF
  $decoded =~ s/\r\n/\n/smg;
  # to utf8
  my $utf8 = encode_utf8($decoded);

  my $bak = "$arg.bak";
  unless (rename $arg, $bak) {
    print "$arg: cannot rename to $bak: $!\n";
    next;
  }
  my $wfh;
  unless (open $wfh, '>', $arg) {
    print "$arg: failed to open for writing: $!\n";
    next;
  }
  binmode $wfh;
  print $wfh $utf8;
  close $wfh;
}
