/*
 * Decompiled with CFR 0.152.
 */
package roboguice.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import com.google.inject.Key;
import java.util.HashMap;
import java.util.Map;
import roboguice.RoboGuice;
import roboguice.event.EventManager;
import roboguice.inject.RoboInjector;
import roboguice.service.event.OnConfigurationChangedEvent;
import roboguice.service.event.OnCreateEvent;
import roboguice.service.event.OnDestroyEvent;
import roboguice.service.event.OnStartEvent;
import roboguice.util.RoboContext;

public abstract class RoboIntentService
extends IntentService
implements RoboContext {
    protected EventManager eventManager;
    protected HashMap<Key<?>, Object> scopedObjects = new HashMap();

    public RoboIntentService(String name) {
        super(name);
    }

    public void onCreate() {
        RoboInjector injector = RoboGuice.getInjector((Context)this);
        this.eventManager = (EventManager)injector.getInstance(EventManager.class);
        injector.injectMembers(this);
        super.onCreate();
        this.eventManager.fire(new OnCreateEvent());
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        this.eventManager.fire(new OnStartEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        try {
            if (this.eventManager != null) {
                this.eventManager.fire(new OnDestroyEvent());
            }
        }
        finally {
            try {
                RoboGuice.destroyInjector((Context)this);
            }
            finally {
                super.onDestroy();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Configuration currentConfig = this.getResources().getConfiguration();
        super.onConfigurationChanged(newConfig);
        this.eventManager.fire(new OnConfigurationChangedEvent(currentConfig, newConfig));
    }

    @Override
    public Map<Key<?>, Object> getScopedObjectMap() {
        return this.scopedObjects;
    }
}

