/*
 * Decompiled with CFR 0.152.
 */
package roboguice.util;

import android.app.Application;
import android.util.Log;
import com.google.inject.Inject;
import roboguice.util.Strings;

public class Ln {
    @Inject
    protected static BaseConfig config = new BaseConfig();
    @Inject
    protected static Print print = new Print();

    private Ln() {
    }

    public static int v(Throwable t) {
        return Ln.config.minimumLogLevel <= 2 ? print.println(2, Log.getStackTraceString((Throwable)t)) : 0;
    }

    public static int v(Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 2) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = args.length > 0 ? String.format(s, args) : s;
        return print.println(2, message);
    }

    public static int v(Throwable throwable, Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 2) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + Log.getStackTraceString((Throwable)throwable);
        return print.println(2, message);
    }

    public static int d(Throwable t) {
        return Ln.config.minimumLogLevel <= 3 ? print.println(3, Log.getStackTraceString((Throwable)t)) : 0;
    }

    public static int d(Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 3) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = args.length > 0 ? String.format(s, args) : s;
        return print.println(3, message);
    }

    public static int d(Throwable throwable, Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 3) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + Log.getStackTraceString((Throwable)throwable);
        return print.println(3, message);
    }

    public static int i(Throwable t) {
        return Ln.config.minimumLogLevel <= 4 ? print.println(4, Log.getStackTraceString((Throwable)t)) : 0;
    }

    public static int i(Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 4) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = args.length > 0 ? String.format(s, args) : s;
        return print.println(4, message);
    }

    public static int i(Throwable throwable, Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 4) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + Log.getStackTraceString((Throwable)throwable);
        return print.println(4, message);
    }

    public static int w(Throwable t) {
        return Ln.config.minimumLogLevel <= 5 ? print.println(5, Log.getStackTraceString((Throwable)t)) : 0;
    }

    public static int w(Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 5) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = args.length > 0 ? String.format(s, args) : s;
        return print.println(5, message);
    }

    public static int w(Throwable throwable, Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 5) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + Log.getStackTraceString((Throwable)throwable);
        return print.println(5, message);
    }

    public static int e(Throwable t) {
        return Ln.config.minimumLogLevel <= 6 ? print.println(6, Log.getStackTraceString((Throwable)t)) : 0;
    }

    public static int e(Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 6) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = args.length > 0 ? String.format(s, args) : s;
        return print.println(6, message);
    }

    public static int e(Throwable throwable, Object s1, Object ... args) {
        if (Ln.config.minimumLogLevel > 6) {
            return 0;
        }
        String s = Strings.toString(s1);
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + Log.getStackTraceString((Throwable)throwable);
        return print.println(6, message);
    }

    public static boolean isDebugEnabled() {
        return Ln.config.minimumLogLevel <= 3;
    }

    public static boolean isVerboseEnabled() {
        return Ln.config.minimumLogLevel <= 2;
    }

    public static Config getConfig() {
        return config;
    }

    public static String logLevelToString(int loglevel) {
        switch (loglevel) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
            case 7: {
                return "ASSERT";
            }
        }
        return "UNKNOWN";
    }

    public static class Print {
        public int println(int priority, String msg) {
            return Log.println((int)priority, (String)Print.getScope(5), (String)this.processMessage(msg));
        }

        protected String processMessage(String msg) {
            if (Ln.config.minimumLogLevel <= 3) {
                msg = String.format("%s %s", Thread.currentThread().getName(), msg);
            }
            return msg;
        }

        protected static String getScope(int skipDepth) {
            if (Ln.config.minimumLogLevel <= 3) {
                StackTraceElement trace = Thread.currentThread().getStackTrace()[skipDepth];
                return Ln.config.scope + "/" + trace.getFileName() + ":" + trace.getLineNumber();
            }
            return Ln.config.scope;
        }
    }

    public static class BaseConfig
    implements Config {
        protected int minimumLogLevel = 2;
        protected String packageName = "";
        protected String scope = "";

        protected BaseConfig() {
        }

        @Inject
        public BaseConfig(Application context) {
            try {
                this.packageName = context.getPackageName();
                int flags = context.getPackageManager().getApplicationInfo((String)this.packageName, (int)0).flags;
                this.minimumLogLevel = (flags & 2) != 0 ? 2 : 4;
                this.scope = this.packageName.toUpperCase();
                Ln.d("Configuring Logging, minimum log level is %s", Ln.logLevelToString(this.minimumLogLevel));
            }
            catch (Exception e) {
                Log.e((String)this.packageName, (String)"Error configuring logger", (Throwable)e);
            }
        }

        @Override
        public int getLoggingLevel() {
            return this.minimumLogLevel;
        }

        @Override
        public void setLoggingLevel(int level) {
            this.minimumLogLevel = level;
        }
    }

    public static interface Config {
        public int getLoggingLevel();

        public void setLoggingLevel(int var1);
    }
}

