package jp.ac.titech.sharp4k.cuten;

import java.io.File;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class Apk {
	private int id;
	private int revision;
	private String name;
	private Task task;

	public Apk(int id, int revision, String name, Task task) {
		this.id = id;
		this.revision = revision;
		this.name = name;
		this.task = task;
	}

	public int getId() {
		return id;
	}

	public int getRevision() {
		return revision;
	}

	public String getClassName() {
		return name;
	}

	public Task getTask() {
		return task;
	}

	public long save(SQLiteDatabase db) {
		ContentValues row = new ContentValues();
		row.put("id", getId());
		row.put("name", getClassName());
		row.put("revision", getRevision());
		row.put("task_id", getTask().getId());
		return db.insertWithOnConflict("apks", null, row,
				SQLiteDatabase.CONFLICT_REPLACE);
	}

	public static Apk find(SQLiteDatabase db, int id) {
		Cursor c = db.rawQuery("SELECT apks.revision, apks.name, apks.task_id"
				+ " FROM apks, tasks" + " WHERE apks.id = ?" + " LIMIT 1",
				new String[] { String.valueOf(id) });
		if (c.moveToNext()) {
			Apk apk = new Apk(id, c.getInt(0), c.getString(1), Task.find(db,
					c.getInt(2)));
			c.close();
			return apk;
		} else {
			c.close();
			return null;
		}
	}

	public File getSavedPath(Context context) {
		return new File(context.getDir("apks", Context.MODE_PRIVATE), getId()
				+ "-" + getRevision() + ".apk");
	}
}
