package jp.ac.titech.sharp4k.cuten;

import java.io.File;
import java.lang.reflect.Method;

import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;

public class ApkResources extends Resources {
	public ApkResources(Resources parent, File apkFile) {
		super(createAssetManager(apkFile), new DisplayMetrics(),
				new Configuration(parent.getConfiguration()));
		getDisplayMetrics().setTo(parent.getDisplayMetrics());
	}

	private static AssetManager createAssetManager(File apkFile) {
		Class<AssetManager> klass = AssetManager.class;
		try {
			AssetManager am = klass.newInstance();
			Method meth = klass.getMethod("addAssetPath", String.class);
			meth.invoke(am, apkFile.getAbsolutePath());
			return am;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
}
