package jp.ac.titech.sharp4k.cuten;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LectureFolder implements PandaGroup<Lecture> {
	private String title;
	private List<Lecture> lectures;
	private boolean isDefault;

	public LectureFolder(String title) {
		this(title, new ArrayList<Lecture>());
	}

	public LectureFolder(String title, List<Lecture> lectures) {
		this.title = title;
		this.lectures = lectures;
		this.isDefault = false;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTitle() {
		return title;
	}

	public List<Lecture> getLectures() {
		return lectures;
	}

	public void setDefault() {
		isDefault = true;
	}

	public boolean isDefault() {
		return isDefault;
	}

	public void add(Lecture lecture) {
		getLectures().add(lecture);
		sortLectureList();
	}

	public void addAll(Collection<? extends Lecture> lectures) {
		getLectures().addAll(lectures);
		sortLectureList();
	}

	public Lecture get(int pos) {
		return getLectures().get(pos);
	}

	public Lecture remove(int pos) {
		return getLectures().remove(pos);
	}

	@Override
	public String getLabel() {
		return title;
	}

	@Override
	public List<Lecture> getChildren() {
		return getLectures();
	}

	public void sortLectureList() {
		Collections.sort(lectures, new Comparator<Lecture>() {
			@Override
			public int compare(Lecture rec1, Lecture lec2) {
				return rec1.getName().compareTo(lec2.getName());
			}
		});
	}
}
