package jp.ac.titech.sharp4k.cuten;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import roboguice.RoboGuice;
import android.app.Application;

public class Main extends Application {
	private AchievementsConsumer consumer;

	@Override
	public void onCreate() {
		BlockingQueue<Achievement> queue = new LinkedBlockingQueue<Achievement>();
		AchievementsSender.init(queue);
		HttpAPIClient apiClient = RoboGuice.getBaseApplicationInjector(this)
				.getInstance(HttpAPIClient.class);
		consumer = new AchievementsConsumer(this, queue, apiClient);
		consumer.start();
	}

	@Override
	public void onTerminate() {
		consumer.stop();
	}
}
