package jp.ac.titech.sharp4k.cuten;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Toast;
import dalvik.system.DexClassLoader;

public class TaskActivity extends Activity {
	private static final String TAG = "TaskActivity";

	public static final String APK_ID_KEY = "apkId";
	public static final String RESULT_KEY = "result";

	private SQLiteDatabase db;

	private BaseApp taskApp;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		int apkId = getIntent().getIntExtra(APK_ID_KEY, -1);
		db = new SQLHelper(this).getReadableDatabase();
		final Task task;
		final Apk apk;
		String qualName = null;
		File apkFile = null;
		if (BuildConfig.DEBUG && apkId == -1) {
			task = new Task(-1, "DEBUG", null);
			apk = new Apk(-1, 1, "", task);
			// Find debuggee apk from /sdcard.
			// The debuggee's file name must be "full-class-name.apk".
			for (File file : Environment.getExternalStorageDirectory()
					.listFiles()) {
				if (file.isFile() && file.canRead()
						&& file.getName().endsWith(".apk")) {
					qualName = file.getName().substring(0,
							file.getName().length() - 4);
					final String apkName = "debug.apk";
					try {
						FileInputStream fis = new FileInputStream(file);
						apkFile = new File(
								getDir("apks", Context.MODE_PRIVATE), apkName);
						FileOutputStream fos = new FileOutputStream(apkFile);
						FileChannel in = fis.getChannel();
						FileChannel out = fos.getChannel();
						in.transferTo(0, in.size(), out);
						fis.close();
						fos.close();
					} catch (IOException e) {
						e.printStackTrace();
						qualName = null;
						apkFile = null;
					}
					break;
				}
			}
			if (apkFile == null || qualName == null) {
				Log.e(TAG, "No APK found");
				Toast.makeText(this, "No APK found", Toast.LENGTH_SHORT).show();
				finish();
				return;
			}
		} else {
			apk = Apk.find(db, apkId);
			task = apk.getTask();
			apkFile = apk.getSavedPath(this);
			qualName = apk.getClassName();
		}
		String taskName = task.getName();

		Log.d(TAG, "Try to launch " + qualName + ":" + apkFile);
		try {
			DexClassLoader cl = loadDex(apkFile);
			Class<?> klass = cl.loadClass(qualName);
			Log.d(TAG, "Successfully loaded " + klass.getName());

			taskApp = (BaseApp) klass.newInstance();
			taskApp.setSender(new ResultSender() {
				@Override
				public void send(int[] results) {
					Achievement a = new Achievement(task, results);
					Log.d(TAG, "requested to send: " + a.getResultString());
					Toast.makeText(getApplicationContext(),
							"結果は " + a.getResultString() + " でした",
							Toast.LENGTH_SHORT).show();
					if (!BuildConfig.DEBUG || task.getId() >= 0) {
						boolean changed = a.merge(db);
						if (changed) {
							AchievementsSender.add(a);
						}
					}
				}
			});
			taskApp.setCloseRequester(new CloseRequester() {
				@Override
				public void close() {
					closeApp();
				}
			});
			View view = taskApp.createView(this, new ApkResources(
					getResources(), apkFile));
			Log.d(TAG, "Successfully created view of " + qualName);

			setupLayout(view);
			setResponse(-1);
		} catch (Exception ex) {
			ex.printStackTrace();
			Log.e(TAG, "Failed to launch " + qualName + ":" + qualName);
			Toast.makeText(this, taskName + "を起動できなかった＞＜", Toast.LENGTH_SHORT)
					.show();
			setResult(RESULT_CANCELED);
			finish();
		}
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		if (db != null) {
			db.close();
			db = null;
		}
	}

	private void setResponse(int result) {
		Intent intent = new Intent();
		intent.putExtra(RESULT_KEY, result);
		setResult(RESULT_OK, intent);
	}

	private void setupLayout(View taskView) {
		setContentView(R.layout.task);

		LinearLayout layout = (LinearLayout) findViewById(R.id.task_root_layout);
		layout.addView(taskView);

		ImageButton b = (ImageButton) findViewById(R.id.task_close_button);
		b.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				closeApp();
			}
		});
	}

	private void closeApp() {
		taskApp.onClose();
		setResponse(0);
		finish();
	}

	private DexClassLoader loadDex(File dexFile) throws IOException {
		File odexDir = getDir("odex", Context.MODE_PRIVATE);
		return new DexClassLoader(dexFile.getAbsolutePath(),
				odexDir.getAbsolutePath(), null, getClassLoader());
	}

	// バックボタンを無効化する
	@Override
	public boolean dispatchKeyEvent(KeyEvent e) {
		if (e.getAction() == KeyEvent.ACTION_DOWN
				&& e.getKeyCode() == KeyEvent.KEYCODE_BACK) {
			if (taskApp != null) {
				taskApp.onClose();
				setResponse(0);
			}
		}
		return super.dispatchKeyEvent(e);
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		if (taskApp != null) {
			taskApp.onConfigurationChanged(newConfig);
		}
	}

	@Override
	protected void onPause() {
		super.onPause();
		if (taskApp != null) {
			taskApp.onPause();
		}
	}

	@Override
	protected void onResume() {
		super.onResume();
		if (taskApp != null) {
			taskApp.onResume();
		}
	}
}
