﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Meyn.TestLink;

namespace BTS.Trac.Test
{
    [TestFixture]
    [TestLinkFixture(
        Url = TestLinkConnect.Url,
        ProjectName = TestLinkConnect.ProjectName,
        UserId = TestLinkConnect.UserId,
        TestPlan = TestLinkConnect.TestPlan,
        TestSuite = TestLinkConnect.TestSuite,
        DevKey = TestLinkConnect.DevKey )]
    public class TicketTest
    {
        [SetUp]
        public void SetUp()
        {
            Trac.Connect( TracConnect.Url, TracConnect.UserName, TracConnect.Password );
        }

        [TearDown]
        public void TearDown()
        {
            Trac.Close();
        }

        [Test]
        public void チケットの作成と取得()
        {
            Ticket newTicket = new Ticket();
            newTicket.Summary = "XML_Trac.rpc から登録";
            newTicket.Description = "登録だよん";
            newTicket.Create();

            Ticket ticket = new Ticket();
            ticket.Get( newTicket.ID );

            Assert.AreEqual( ticket.ID, newTicket.ID );
            Assert.AreEqual( ticket.Summary, newTicket.Summary );
            Assert.AreEqual( ticket.Description, newTicket.Description );
        }


        [Test]
        public void チケットの更新()
        {
            Ticket newTicket = new Ticket();
            newTicket.Summary = "XML_Trac.rpc から登録";
            newTicket.Description = "登録だよん";
            newTicket.Create();

            Ticket updateTicket = new Ticket( newTicket.ID );
            updateTicket.Summary = "概要を変更したよん";
            updateTicket.Description = "詳細を変更したよん";
            updateTicket.Update( "更新のテスト" );

            Ticket ticket = new Ticket( updateTicket.ID );

            Assert.AreEqual( ticket.ID, updateTicket.ID );
            Assert.AreEqual( ticket.Summary, updateTicket.Summary );
            Assert.AreEqual( ticket.Description, updateTicket.Description );
        }

        [Test]
        public void チケット数の取得()
        {
            int[] ticketsPoint1 = Ticket.Query( "status!=closed" );

            Ticket newTicket1 = new Ticket();
            newTicket1.Summary = "XML_Trac.rpc から登録1";
            newTicket1.Description = "登録だよん1";
            newTicket1.Create();

            int[] ticketsPoint2 = Ticket.Query( "status!=closed" );
            Assert.AreEqual( ticketsPoint1.Length + 1, ticketsPoint2.Length );

            Ticket newTicket2 = new Ticket();
            newTicket2.Summary = "XML_Trac.rpc から登録1";
            newTicket2.Description = "登録だよん1";
            newTicket2.Create();

            int[] ticketsPoint3 = Ticket.Query( "status!=closed" );
            Assert.AreEqual( ticketsPoint1.Length + 2, ticketsPoint3.Length );
        }

        [Test]
        public void チケットの削除()
        {
            int[] ticketsPoint1 = Ticket.Query( "status!=closed" );

            Ticket newTicket1 = new Ticket();
            newTicket1.Summary = "XML_Trac.rpc から登録1";
            newTicket1.Description = "登録だよん1";
            newTicket1.Create();

            int[] ticketsPoint2 = Ticket.Query( "status!=closed" );
            Assert.AreEqual( ticketsPoint1.Length + 1, ticketsPoint2.Length );

            foreach ( int ticketId in ticketsPoint2 ) {
                Ticket ticket = new Ticket( ticketId );
                ticket.Delete();
            }

            int[] ticketsPoint3 = Ticket.Query( "status!=closed" );
            Assert.AreEqual( ticketsPoint3.Length, 0 );
        }

        [Test]
        public void 添付ファイルの数を取得()
        {
            Ticket newTicket1 = new Ticket();
            newTicket1.Summary = "XML_Trac.rpc から登録1";
            newTicket1.Description = "登録だよん1";
            newTicket1.Create();

            TicketAttachment[] attachments = newTicket1.ListAttachments();
            Assert.AreEqual( attachments.Length, 0 );
        }
    }
}
