﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// ITemplateProvider インタフェースの生成
    /// </summary>
    public class TemplateProvider : CodeGeneratorEnvironment, ICodeGenerator
    {
        public TemplateProvider()
        {
        }

        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.web.chrome import ITemplateProvider\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "ITemplateProvider";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "ITemplateProvider.py.template" );
        }
    }
}
