﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using Office=Microsoft.Office.Core;

namespace ExcelRedmineAddIn
{
    public class Option
    {
        /// <summary>
        /// Redmine URL
        /// </summary>
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// API キー
        /// </summary>
        public string ApiKey
        {
            get;
            set;
        }

        /// <summary>
        /// 起票者メールアドレス
        /// </summary>
        public string MailAddress
        {
            get;
            set;
        }

        /// <summary>
        /// プロジェクト識別子
        /// </summary>
        public string Project
        {
            get;
            set;
        }

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public Option()
        {
            Url = ApiKey = MailAddress = Project = "";
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="path">復元パス</param>
        public Option( string path, ref Office.CommandBar menubar )
        {
            Load( path, ref menubar );
        }

        /// <summary>
        /// 保存
        /// </summary>
        /// <param name="path">保存パス</param>
        public void Save( string path, Office.CommandBar menubar )
        {
            Trace.WriteLine( path );

            // XML として保存
            XmlDocument xml = new XmlDocument();
            xml.AppendChild( xml.CreateXmlDeclaration("1.0", "utf-8", null ) );

            XmlNode root = xml.CreateElement( "root" );

            XmlNode menu = AppendChild( xml, root, "menubar" );
            AppendChild( xml, menu, "top", menubar.Top.ToString() );
            AppendChild( xml, menu, "left", menubar.Left.ToString() );
            AppendChild( xml, menu, "visible", menubar.Visible.ToString() );
            AppendChild( xml, menu, "position", ((int)menubar.Position).ToString() );
            AppendChild( xml, menu, "rowindex", menubar.RowIndex.ToString() );

            AppendChild( xml, root, "url", Url );
            AppendChild( xml, root, "apikey", ApiKey );
            AppendChild( xml, root, "mailaddress", MailAddress );
            AppendChild( xml, root, "project", Project );

            xml.AppendChild( root );

            // 保存
            xml.Save( path );
        }

        /// <summary>
        /// 復元
        /// </summary>
        /// <param name="path">復元パス</param>
        public void Load( string path, ref Office.CommandBar menubar )
        {
            Trace.WriteLine( path );

            // XML から復元
            XmlDocument xml = new XmlDocument();
            xml.Load( path );

            try {
                menubar.Top = int.Parse( xml.SelectNodes( "//top" )[0].InnerText );
                menubar.Left = int.Parse( xml.SelectNodes( "//left" )[0].InnerText );
                menubar.Visible = bool.Parse( xml.SelectNodes( "//visible" )[0].InnerText );
                menubar.Position = (Office.MsoBarPosition)int.Parse( xml.SelectNodes( "//position" )[0].InnerText );
                menubar.RowIndex = int.Parse( xml.SelectNodes( "//rowindex" )[0].InnerText );
            }
            catch {
                // エラーの時はデフォルト値を設定
                menubar.Visible = true;
                menubar.Position = Microsoft.Office.Core.MsoBarPosition.msoBarTop;
            }

            Url = xml.SelectNodes( "//url" )[0].InnerText;
            ApiKey = xml.SelectNodes( "//apikey" )[0].InnerText;
            MailAddress = xml.SelectNodes( "//mailaddress" )[0].InnerText;
            Project = xml.SelectNodes( "//project" )[0].InnerText;
        }

        /// <summary>
        /// 子要素の作成
        /// </summary>
        /// <param name="xml"></param>
        /// <param name="parent"></param>
        /// <param name="tag"></param>
        /// <param name="text"></param>
        /// <returns></returns>
        private XmlNode AppendChild( XmlDocument xml, XmlNode parent, string tag, string text )
        {
            XmlNode child = xml.CreateElement( tag );
            child.AppendChild( xml.CreateTextNode( text ) );
            parent.AppendChild( child );

            return child;
        }

        /// <summary>
        /// 子要素の作成
        /// </summary>
        /// <param name="xml"></param>
        /// <param name="parent"></param>
        /// <param name="tag"></param>
        /// <returns></returns>
        private XmlNode AppendChild( XmlDocument xml, XmlNode parent, string tag )
        {
            return parent.AppendChild( xml.CreateElement( tag ) );;
        }
    }
}
