using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration.Install;
using System.Diagnostics;
using System.Windows.Forms;

namespace CustomInstaller
{
    [RunInstaller(true)]
    public partial class CustomInstaller : Installer
    {
        public CustomInstaller()
        {
            InitializeComponent();
        }

        public override void Commit(System.Collections.IDictionary savedState)
        {
            base.Commit(savedState);
            string targetDir = this.Context.Parameters["TargetDir"];
            string windir = Environment.GetEnvironmentVariable("windir");
            ProcessStartInfo info = new ProcessStartInfo();
            info.FileName = windir + @"\Microsoft.NET\Framework\v2.0.50727\regasm.exe";
            info.Arguments = targetDir + "VSSLog2Trac.dll";
            info.WindowStyle = ProcessWindowStyle.Hidden;
            Process.Start(info);
        }

        public override void Uninstall(System.Collections.IDictionary savedState)
        {
            base.Uninstall(savedState);
            string targetDir = this.Context.Parameters["TargetDir"];

            string windir = Environment.GetEnvironmentVariable("windir");
            ProcessStartInfo info = new ProcessStartInfo();
            info.FileName = windir + @"\Microsoft.NET\Framework\v2.0.50727\regasm.exe";
            info.Arguments = "/unregister " + targetDir + "VSSLog2Trac.dll";
            info.WindowStyle = ProcessWindowStyle.Hidden;
            Process.Start(info);
        }
    }
}