using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;

namespace XmlRpcProxy
{
    [XmlRoot("methodResponse")]
    public class MethodResponse
    {
        private List<Param> _paramArray;

        private Fault _fault;

        [XmlArray("params")]
        [XmlArrayItem("param")]
        public List<Param> ParamArray
        {
            get
            {
                return _paramArray;
            }
            set
            {
                _paramArray = value;
            }
        }
        
        [XmlElement("fault")]
        public Fault Fault
        {
            get { return _fault; }
            set { _fault = value; }
        }

        public MethodResponse()
            : this(new object[] { })
        {
        }

        public MethodResponse(object[] paramArray)
        {
            _paramArray = new List<Param>();
            foreach (object param in paramArray)
            {
                _paramArray.Add(new Param(param));
            }
        }
    }

    public class Fault
    {
        private ValueContent _value;

        [XmlElement("value")]
        public ValueContent Value
        {
            get
            {
                return _value;
            }
            set
            {
                _value = value;
            }
        }
    }
}
