# -*- coding: utf-8 -*-
"""
Created on 2010/08/07
@author: @tomosnowbug
"""
from multirepositoryhelper.plugin import MultiRepositoryHelperPlugin
from test.test_datetime import FixedOffset
from trac.core import ComponentMeta, ComponentManager, ComponentMeta, \
    ComponentManager
from trac.test import EnvironmentStub, Mock
from trac.ticket.model import Ticket
import unittest

utc = FixedOffset(0, 'UTC')

class MultiRepositoryHelperPluginTest(unittest.TestCase):
    
    def setUp(self):
        self.env = EnvironmentStub()
        self.db = self.env.get_db_cnx()
        import sys
        self.log = Mock(info=lambda str: sys.stdout.write("INFO :" + str + '\n') ,
                        debug=lambda str: sys.stdout.write("DEBUG:" + str + '\n'),
                        warn=lambda str: sys.stdout.write("WARN :" + str + '\n'),
                        )
        
        self.compmgr = ComponentManager()
        self.plugin = MultiRepositoryHelperPlugin(self.compmgr)
        setattr(self.plugin, "env", self.env)
        setattr(self.plugin, "log", self.log)
    
    def tearDown(self):
        self.db.close()
        self.env.shutdown() # really closes the db connections
    
    def testNewClass(self):
        self.assertNotEqual(MultiRepositoryHelperPlugin(self.compmgr), None)
        
    def test_update_ticket(self):
        
        #create new ticet#1
        ticket = Ticket(self.env)
        ticket['reporter'] = 'santa'
        ticket['summary'] = 'Foo'
        ticket.insert()
        
        update_author = "tomosnowbug"
        ticket_comment = "refs #My Project/1 from unit test."
        repos_name = "test repository"
        changeset_rev = 10
        self.plugin.update_ticket(repos_name, changeset_rev,
                                   update_author, ticket_comment)
        changes = ticket.get_changelog()
        print changes
        
        self.assertEqual(changes[0][1], update_author)
        self.assertEqual(changes[0][4], 
                         "in [%d/%s] \n%s" %\
                          (changeset_rev, repos_name, ticket_comment))
        ticket.delete(self.db)

if __name__ == '__main__':
    unittest.main()

