import urllib

from trac.core import *
from trac.wiki.api import IWikiMacroProvider
from trac.config import Option

class PukiwikiConverter(Component):
    implements(IWikiMacroProvider)

    def get_macros(self):
        yield 'pukiwiki'

    def get_macro_description(self, name):
        return '''desc'''

    def expand_macro(self, formatter, name, content):
        if name == 'pukiwiki':
            content = content.encode('utf-8')
            params = urllib.urlencode({'convert_data': content})
            url = self.env.config.get('pukiwiki-processor', 'converter_url')
            if not url:
                raise TracError("You must setting converter_url under [pukiwiki-processor] in trac.ini.");

            try :
                d = urllib.urlopen(url, params)
                result = d.read()
                d.close()
                return result
            except IOError:
                raise TracError("IOError can't open ["+url+"]");    
    # deprecated interface prior trac 0.11
    def render_macro(self, req, name, content):
        return self.expand_macro(None, name, content)

