#!-*- coding:utf-8 -*-"

from trac.util.translation import _

def convertfloat(x):
    "some european countries use , as the decimal separator"
    x = str(x).strip()
    if len(x) > 0:
        return float(x.replace(',', '.'))
    else: 
        return 0.0
    
def assert_modify_permission(env, req):
    from trac.perm import PermissionSystem, PermissionError
    actions = PermissionSystem(env).get_user_permissions(req.authname)
    for action in actions:
        if action.startswith('TICKET_CHGPROP'):
            return
    raise PermissionError('TICKET_CHGPROP', None, env)
    
def get_all_users(env):
    """return the names of all known users in the trac environment"""
    return [i[0] for i in env.get_known_users()]
    
def template(env, template, data={}, method="xhtml"):
    u"""テンプレートよりHTMLを生成する
    """
    from trac.web.chrome import Chrome
    template = Chrome(env).load_template(template, method=method)
    result = template.generate(**data)
    return result