/**
 * Copyright (c) 2009 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris dot leonello at gmail dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 */
(function(e){var b;e.jqplot=function(r,o,l){var n,k;if(o==null){throw"No data specified"}if(o.constructor==Array&&o.length==0||o[0].constructor!=Array){throw"Improper Data Array"}if(l==null){if(o instanceof Array){n=o;k=null}else{if(o.constructor==Object){n=null;k=o}}}else{n=o;k=l}var q=new h();q.init(r,n,k);q.draw();return q};e.jqplot.debug=1;e.jqplot.config={debug:1,enablePlugins:true,defaultHeight:300,defaultWidth:400};e.jqplot.enablePlugins=e.jqplot.config.enablePlugins;e.jqplot.preInitHooks=[];e.jqplot.postInitHooks=[];e.jqplot.preParseOptionsHooks=[];e.jqplot.postParseOptionsHooks=[];e.jqplot.preDrawHooks=[];e.jqplot.postDrawHooks=[];e.jqplot.preDrawSeriesHooks=[];e.jqplot.postDrawSeriesHooks=[];e.jqplot.preDrawLegendHooks=[];e.jqplot.addLegendRowHooks=[];e.jqplot.preSeriesInitHooks=[];e.jqplot.postSeriesInitHooks=[];e.jqplot.preParseSeriesOptionsHooks=[];e.jqplot.postParseSeriesOptionsHooks=[];e.jqplot.eventListenerHooks=[];e.jqplot.preDrawSeriesShadowHooks=[];e.jqplot.postDrawSeriesShadowHooks=[];e.jqplot.ElemContainer=function(){this._elem;this._plotWidth;this._plotHeight;this._plotDimensions={height:null,width:null}};e.jqplot.ElemContainer.prototype.getWidth=function(){if(this._elem){return this._elem.outerWidth(true)}else{return null}};e.jqplot.ElemContainer.prototype.getHeight=function(){if(this._elem){return this._elem.outerHeight(true)}else{return null}};e.jqplot.ElemContainer.prototype.getPosition=function(){if(this._elem){return this._elem.position()}else{return{top:null,left:null,bottom:null,right:null}}};e.jqplot.ElemContainer.prototype.getTop=function(){return this.getPosition().top};e.jqplot.ElemContainer.prototype.getLeft=function(){return this.getPosition().left};e.jqplot.ElemContainer.prototype.getBottom=function(){return this._elem.css("bottom")};e.jqplot.ElemContainer.prototype.getRight=function(){return this._elem.css("right")};function g(k){e.jqplot.ElemContainer.call(this);this.name=k;this._series=[];this.show=false;this.tickRenderer=e.jqplot.AxisTickRenderer;this.tickOptions={};this.labelRenderer=e.jqplot.AxisLabelRenderer;this.labelOptions={};this.label=null;this.showLabel=true;this.min=null;this.max=null;this.autoscale=false;this.pad=1.2;this.padMax=null;this.padMin=null;this.ticks=[];this.numberTicks;this.tickInterval;this.renderer=e.jqplot.LinearAxisRenderer;this.rendererOptions={};this.showTicks=true;this.showTickMarks=true;this.showMinorTicks=true;this.useSeriesColor=false;this.borderWidth=null;this.borderColor=null;this._dataBounds={min:null,max:null};this._offsets={min:null,max:null};this._ticks=[];this._label=null;this.syncTicks=null;this.tickSpacing=75;this._min=null;this._max=null;this._tickInterval=null;this._numberTicks=null;this.__ticks=null}g.prototype=new e.jqplot.ElemContainer();g.prototype.constructor=g;g.prototype.init=function(){this.renderer=new this.renderer();this.tickOptions.axis=this.name;if(this.label==null||this.label==""){this.showLabel=false}else{this.labelOptions.label=this.label}if(this.showLabel==false){this.labelOptions.show=false}if(this.pad==0){this.pad=1}if(this.padMax==0){this.padMax=1}if(this.padMin==0){this.padMin=1}if(this.padMax==null){this.padMax=(this.pad-1)/2+1}if(this.padMin==null){this.padMin=(this.pad-1)/2+1}this.pad=this.padMax+this.padMin-1;if(this.min!=null||this.max!=null){this.autoscale=false}if(this.syncTicks==null&&this.name.indexOf("y")>-1){this.syncTicks=true}else{if(this.syncTicks==null){this.syncTicks=false}}this.renderer.init.call(this,this.rendererOptions)};g.prototype.draw=function(k){return this.renderer.draw.call(this,k)};g.prototype.set=function(){this.renderer.set.call(this)};g.prototype.pack=function(l,k){if(this.show){this.renderer.pack.call(this,l,k)}if(this._min==null){this._min=this.min;this._max=this.max;this._tickInterval=this.tickInterval;this._numberTicks=this.numberTicks;this.__ticks=this._ticks}};g.prototype.reset=function(){this.renderer.reset.call(this)};function a(k){e.jqplot.ElemContainer.call(this);this.show=false;this.location="ne";this.xoffset=12;this.yoffset=12;this.border;this.background;this.textColor;this.fontFamily;this.fontSize;this.rowSpacing="0.5em";this.renderer=e.jqplot.TableLegendRenderer;this.rendererOptions={};this.preDraw=false;this.escapeHtml=false;this._series=[];e.extend(true,this,k)}a.prototype=new e.jqplot.ElemContainer();a.prototype.constructor=a;a.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};a.prototype.draw=function(l){for(var k=0;k<e.jqplot.preDrawLegendHooks.length;k++){e.jqplot.preDrawLegendHooks[k].call(this,l)}return this.renderer.draw.call(this,l)};a.prototype.pack=function(k){this.renderer.pack.call(this,k)};e.jqplot.TableLegendRenderer=function(){};function f(k){e.jqplot.ElemContainer.call(this);this.text=k;this.show=true;this.fontFamily;this.fontSize;this.textAlign;this.textColor;this.renderer=e.jqplot.DivTitleRenderer;this.rendererOptions={}}f.prototype=new e.jqplot.ElemContainer();f.prototype.constructor=f;f.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};f.prototype.draw=function(k){return this.renderer.draw.call(this,k)};f.prototype.pack=function(){this.renderer.pack.call(this)};function j(){e.jqplot.ElemContainer.call(this);this.show=true;this.xaxis="xaxis";this._xaxis;this.yaxis="yaxis";this._yaxis;this.gridBorderWidth=2;this.renderer=e.jqplot.LineRenderer;this.rendererOptions={};this.data=[];this.gridData=[];this.label="";this.showLabel=true;this.color;this.lineWidth=2.5;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.25;this.shadowDepth=3;this.shadowAlpha="0.1";this.breakOnNull=false;this.markerRenderer=e.jqplot.MarkerRenderer;this.markerOptions={};this.showLine=true;this.showMarker=true;this.index;this.fill=false;this.fillColor;this.fillAlpha;this.fillAndStroke=false;this.disableStack=false;this._stack=false;this.neighborThreshold=4;this.fillToZero=false;this.fillAxis="y";this._stackData=[];this._plotData=[];this._plotValues={x:[],y:[]};this._intervals={x:{},y:{}};this._prevPlotData=[];this._prevGridData=[];this._stackAxis="y";this._primaryAxis="_xaxis";this.plugins={}}j.prototype=new e.jqplot.ElemContainer();j.prototype.constructor=j;j.prototype.init=function(l,r){this.index=l;this.gridBorderWidth=r;var q=this.data;for(var n=0;n<q.length;n++){if(!this.breakOnNull){if(q[n]==null||q[n][0]==null||q[n][1]==null){q.splice(n,1);continue}}else{if(q[n]==null||q[n][0]==null||q[n][1]==null){var o}}}if(!this.fillColor){this.fillColor=this.color}if(this.fillAlpha){var k=e.jqplot.normalize2rgb(this.fillColor);var k=e.jqplot.getColorComponents(k);this.fillColor="rgba("+k[0]+","+k[1]+","+k[2]+","+this.fillAlpha+")"}this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions);this.markerRenderer=new this.markerRenderer();if(!this.markerOptions.color){this.markerOptions.color=this.color}if(this.markerOptions.show==null){this.markerOptions.show=this.showMarker}this.markerRenderer.init(this.markerOptions)};j.prototype.draw=function(r,o){var l=(o==b)?{}:o;for(var k=0;k<e.jqplot.preDrawSeriesHooks.length;k++){e.jqplot.preDrawSeriesHooks[k].call(this,r,l)}if(this.show){this.renderer.setGridData.call(this);if(!l.preventJqPlotSeriesDrawTrigger){e(r.canvas).trigger("jqplotSeriesDraw",[this.data,this.gridData])}var q=[];if(l.data){q=l.data}else{if(!this._stack){q=this.data}else{q=this._plotData}}var n=l.gridData||this.renderer.makeGridData.call(this,q);this.renderer.draw.call(this,r,n,l)}for(var k=0;k<e.jqplot.postDrawSeriesHooks.length;k++){e.jqplot.postDrawSeriesHooks[k].call(this,r,l)}};j.prototype.drawShadow=function(r,o){var l=(o==b)?{}:o;for(var k=0;k<e.jqplot.preDrawSeriesShadowHooks.length;k++){e.jqplot.preDrawSeriesShadowHooks[k].call(this,r,l)}if(this.shadow){this.renderer.setGridData.call(this);var q=[];if(l.data){q=l.data}else{if(!this._stack){q=this.data}else{q=this._plotData}}var n=l.gridData||this.renderer.makeGridData.call(this,q);this.renderer.drawShadow.call(this,r,n,l)}for(var k=0;k<e.jqplot.postDrawSeriesShadowHooks.length;k++){e.jqplot.postDrawSeriesShadowHooks[k].call(this,r,l)}};function d(){e.jqplot.ElemContainer.call(this);this.drawGridlines=true;this.gridLineColor="#cccccc";this.gridLineWidth=1;this.background="#fffdf6";this.borderColor="#999999";this.borderWidth=2;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.5;this.shadowWidth=3;this.shadowDepth=3;this.shadowAlpha="0.07";this._left;this._top;this._right;this._bottom;this._width;this._height;this._axes=[];this.renderer=e.jqplot.CanvasGridRenderer;this.rendererOptions={};this._offsets={top:null,bottom:null,left:null,right:null}}d.prototype=new e.jqplot.ElemContainer();d.prototype.constructor=d;d.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};d.prototype.createElement=function(k){this._offsets=k;return this.renderer.createElement.call(this)};d.prototype.draw=function(){this.renderer.draw.call(this)};e.jqplot.GenericCanvas=function(){e.jqplot.ElemContainer.call(this);this._ctx};e.jqplot.GenericCanvas.prototype=new e.jqplot.ElemContainer();e.jqplot.GenericCanvas.prototype.constructor=e.jqplot.GenericCanvas;e.jqplot.GenericCanvas.prototype.createElement=function(q,n,l){this._offsets=q;var k="jqplot";if(n!=b){k=n}var o=document.createElement("canvas");if(l!=b){this._plotDimensions=l}o.width=this._plotDimensions.width-this._offsets.left-this._offsets.right;o.height=this._plotDimensions.height-this._offsets.top-this._offsets.bottom;this._elem=e(o);this._elem.addClass(k);this._elem.css({position:"absolute",left:this._offsets.left,top:this._offsets.top});if(e.browser.msie){window.G_vmlCanvasManager.init_(document)}if(e.browser.msie){o=window.G_vmlCanvasManager.initElement(o)}return this._elem};e.jqplot.GenericCanvas.prototype.setContext=function(){this._ctx=this._elem.get(0).getContext("2d");return this._ctx};function h(){this.data=[];this.targetId=null;this.target=null;this.defaults={axesDefaults:{},axes:{xaxis:{},yaxis:{},x2axis:{},y2axis:{},y3axis:{},y4axis:{},y5axis:{},y6axis:{},y7axis:{},y8axis:{},y9axis:{}},seriesDefaults:{},gridPadding:{top:10,right:10,bottom:10,left:10},series:[]};this.series=[];this.axes={xaxis:new g("xaxis"),yaxis:new g("yaxis"),x2axis:new g("x2axis"),y2axis:new g("y2axis"),y3axis:new g("y3axis"),y4axis:new g("y4axis"),y5axis:new g("y5axis"),y6axis:new g("y6axis"),y7axis:new g("y7axis"),y8axis:new g("y8axis"),y9axis:new g("y9axis")};this.grid=new d();this.legend=new a();this.baseCanvas=new e.jqplot.GenericCanvas();this.seriesCanvas=new e.jqplot.GenericCanvas();this.eventCanvas=new e.jqplot.GenericCanvas();this._width=null;this._height=null;this._plotDimensions={height:null,width:null};this._gridPadding={top:10,right:10,bottom:10,left:10};this.syncXTicks=true;this.syncYTicks=true;this.seriesColors=["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc"];this.negativeSeriesColors=["#498991","#C08840","#9F9274","#546D61","#646C4A","#6F6621","#6E3F5F","#4F64B0","#A89050","#C45923","#187399"];this.sortData=true;var o=0;this.textColor;this.fontFamily;this.fontSize;this.title=new f();this.options={};this.stackSeries=false;this._stackData=[];this._plotData=[];this.plugins={};this.colorGenerator=e.jqplot.ColorGenerator;this.init=function(z,y,u){for(var v=0;v<e.jqplot.preInitHooks.length;v++){e.jqplot.preInitHooks[v].call(this,z,y,u)}this.targetId="#"+z;this.target=e("#"+z);if(!this.target.get(0)){throw"No plot target specified"}if(this.target.css("position")=="static"){this.target.css("position","relative")}if(!this.target.hasClass("jqplot-target")){this.target.addClass("jqplot-target")}if(!this.target.height()){var x;if(u&&u.height){x=parseInt(u.height,10)}else{if(this.target.attr("data-height")){x=parseInt(this.target.attr("data-height"),10)}else{x=parseInt(e.jqplot.config.defaultHeight,10)}}this._height=x;this.target.css("height",x+"px")}else{this._height=this.target.height()}if(!this.target.width()){var q;if(u&&u.width){q=parseInt(u.width,10)}else{if(this.target.attr("data-width")){q=parseInt(this.target.attr("data-width"),10)}else{q=parseInt(e.jqplot.config.defaultWidth,10)}}this._width=q;this.target.css("width",q+"px")}else{this._width=this.target.width()}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.seriesCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Canvas dimensions <=0"}this.data=y;this.parseOptions(u);if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this.title.init();this.legend.init();for(var v=0;v<this.series.length;v++){for(var t=0;t<e.jqplot.preSeriesInitHooks.length;t++){e.jqplot.preSeriesInitHooks[t].call(this.series[v],z,y,this.options.seriesDefaults,this.options.series[v])}this.populatePlotData(this.series[v],v);this.series[v]._plotDimensions=this._plotDimensions;this.series[v].init(v,this.grid.borderWidth);for(var t=0;t<e.jqplot.postSeriesInitHooks.length;t++){e.jqplot.postSeriesInitHooks[t].call(this.series[v],z,y,this.options.seriesDefaults,this.options.series[v])}}for(var r in this.axes){this.axes[r]._plotDimensions=this._plotDimensions;this.axes[r].init()}if(this.sortData){k(this.series)}this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(var v=0;v<e.jqplot.postInitHooks.length;v++){e.jqplot.postInitHooks[v].call(this,z,y,u)}};function k(v){var w,t;for(var u=0;u<v.length;u++){w=v[u].data;var q=true;if(v[u]._stackAxis=="x"){for(var r=0;r<w.length;r++){if(typeof(w[r][1])!="number"){q=false;break}}if(q){w.sort(function(y,x){return y[1]-x[1]})}}else{for(var r=0;r<w.length;r++){if(typeof(w[r][0])!="number"){q=false;break}}if(q){w.sort(function(y,x){return y[0]-x[0]})}}}}this.populatePlotData=function(v,w){this._plotData=[];this._stackData=[];v._stackData=[];v._plotData=[];var z={x:[],y:[]};if(this.stackSeries&&!v.disableStack){v._stack=true;var x=v._stackAxis=="x"?0:1;var y=x?0:1;var A=e.extend(true,[],v.data);var B=e.extend(true,[],v.data);for(var t=0;t<w;t++){var q=this.series[t].data;for(var r=0;r<q.length;r++){A[r][0]+=q[r][0];A[r][1]+=q[r][1];B[r][x]+=q[r][x]}}for(var u=0;u<B.length;u++){z.x.push(B[u][0]);z.y.push(B[u][1])}this._plotData.push(B);this._stackData.push(A);v._stackData=A;v._plotData=B;v._plotValues=z}else{for(var u=0;u<v.data.length;u++){z.x.push(v.data[u][0]);z.y.push(v.data[u][1])}this._stackData.push(v.data);this.series[w]._stackData=v.data;this._plotData.push(v.data);v._plotData=v.data;v._plotValues=z}if(w>0){v._prevPlotData=this.series[w-1]._plotData}};this.getNextSeriesColor=(function(r){var q=0;var u=r.seriesColors;return function(){if(q<u.length){return u[q++]}else{q=0;return u[q++]}}})(this);this.parseOptions=function(u){for(var v=0;v<e.jqplot.preParseOptionsHooks.length;v++){e.jqplot.preParseOptionsHooks[v].call(this,u)}this.options=e.extend(true,{},this.defaults,u);this.stackSeries=this.options.stackSeries;if(this.options.seriesColors){this.seriesColors=this.options.seriesColors}var x=new this.colorGenerator(this.seriesColors);e.extend(true,this._gridPadding,this.options.gridPadding);this.sortData=(this.options.sortData!=null)?this.options.sortData:this.sortData;for(var y in this.axes){var w=this.axes[y];e.extend(true,w,this.options.axesDefaults,this.options.axes[y]);w._plotWidth=this._width;w._plotHeight=this._height}if(this.data.length==0){this.data=[];for(var v=0;v<this.options.series.length;v++){this.data.push(this.options.series.data)}}var t=function(B){var z=[];var A;if(!(B[0] instanceof Array)){for(var A=0;A<B.length;A++){z.push([A+1,B[A]])}}else{e.extend(true,z,B)}return z};for(var v=0;v<this.data.length;v++){var q=new j();for(var r=0;r<e.jqplot.preParseSeriesOptionsHooks.length;r++){e.jqplot.preParseSeriesOptionsHooks[r].call(q,this.options.seriesDefaults,this.options.series[v])}e.extend(true,q,{seriesColors:this.seriesColors,negativeSeriesColors:this.negativeSeriesColors},this.options.seriesDefaults,this.options.series[v]);q.data=t(this.data[v]);switch(q.xaxis){case"xaxis":q._xaxis=this.axes.xaxis;break;case"x2axis":q._xaxis=this.axes.x2axis;break;default:break}q._yaxis=this.axes[q.yaxis];q._xaxis._series.push(q);q._yaxis._series.push(q);if(q.show){q._xaxis.show=true;q._yaxis.show=true}if(!q.color&&q.show!=false){q.color=x.next()}if(!q.label){q.label="Series "+(v+1).toString()}this.series.push(q);for(var r=0;r<e.jqplot.postParseSeriesOptionsHooks.length;r++){e.jqplot.postParseSeriesOptionsHooks[r].call(this.series[v],this.options.seriesDefaults,this.options.series[v])}}e.extend(true,this.grid,this.options.grid);for(var y in this.axes){var w=this.axes[y];if(w.borderWidth==null){w.borderWidth=this.grid.borderWidth}if(w.borderColor==null){if(y!="xaxis"&&y!="x2axis"&&w.useSeriesColor===true&&w.show){w.borderColor=w._series[0].color}else{w.borderColor=this.grid.borderColor}}}if(typeof this.options.title=="string"){this.title.text=this.options.title}else{if(typeof this.options.title=="object"){e.extend(true,this.title,this.options.title)}}this.title._plotWidth=this._width;e.extend(true,this.legend,this.options.legend);for(var v=0;v<e.jqplot.postParseOptionsHooks.length;v++){e.jqplot.postParseOptionsHooks[v].call(this,u)}};this.redraw=function(){this.target.trigger("jqplotPreRedraw");this.target.empty();for(var r in this.axes){this.axes[r]._ticks=[]}for(var q=0;q<this.series.length;q++){this.populatePlotData(this.series[q],q)}this.draw();this.target.trigger("jqplotPostRedraw")};this.draw=function(){this.target.trigger("jqplotPreDraw");for(var x=0;x<e.jqplot.preDrawHooks.length;x++){e.jqplot.preDrawHooks[x].call(this)}this.target.append(this.baseCanvas.createElement({left:0,right:0,top:0,bottom:0},"jqplot-base-canvas"));var w=this.baseCanvas.setContext();this.target.append(this.title.draw());this.title.pack({top:0,left:0});for(var t in this.axes){this.target.append(this.axes[t].draw(w));this.axes[t].set()}if(this.axes.yaxis.show){this._gridPadding.left=this.axes.yaxis.getWidth()}var u=["y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var r=[0,0,0,0];var z=0;for(var v=8;v>0;v--){var q=this.axes[u[v-1]];if(q.show){r[v-1]=z;z+=q.getWidth()}}if(z>this._gridPadding.right){this._gridPadding.right=z}if(this.title.show&&this.axes.x2axis.show){this._gridPadding.top=this.title.getHeight()+this.axes.x2axis.getHeight()}else{if(this.title.show){this._gridPadding.top=this.title.getHeight()}else{if(this.axes.x2axis.show){this._gridPadding.top=this.axes.x2axis.getHeight()}}}if(this.axes.xaxis.show){this._gridPadding.bottom=this.axes.xaxis.getHeight()}this.axes.xaxis.pack({position:"absolute",bottom:0,left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});this.axes.yaxis.pack({position:"absolute",top:0,left:0,height:this._height},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});this.axes.x2axis.pack({position:"absolute",top:this.title.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});for(var x=8;x>0;x--){this.axes[u[x-1]].pack({position:"absolute",top:0,right:r[x-1]},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top})}this.target.append(this.grid.createElement(this._gridPadding));this.grid.draw();this.target.append(this.seriesCanvas.createElement(this._gridPadding,"jqplot-series-canvas"));var B=this.seriesCanvas.setContext();this.target.append(this.eventCanvas.createElement(this._gridPadding,"jqplot-event-canvas"));var A=this.eventCanvas.setContext();A.fillStyle="rgba(0,0,0,0)";A.fillRect(0,0,A.canvas.width,A.canvas.height);this.bindCustomEvents();if(this.legend.preDraw){this.target.append(this.legend.draw());this.legend.pack(this._gridPadding);if(this.legend._elem){this.drawSeries(B,{legendInfo:{location:this.legend.location,width:this.legend.getWidth(),height:this.legend.getHeight(),xoffset:this.legend.xoffset,yoffset:this.legend.yoffset}})}else{this.drawSeries(B)}}else{this.drawSeries(B);e(this.seriesCanvas._elem).after(this.legend.draw());this.legend.pack(this._gridPadding)}for(var x=0;x<e.jqplot.eventListenerHooks.length;x++){var y=e.jqplot.eventListenerHooks[x];this.eventCanvas._elem.bind(y[0],{plot:this},y[1])}for(var x=0;x<e.jqplot.postDrawHooks.length;x++){e.jqplot.postDrawHooks[x].call(this)}this.target.trigger("jqplotPostDraw",[this])};this.bindCustomEvents=function(){this.eventCanvas._elem.bind("click",{plot:this},this.onClick);this.eventCanvas._elem.bind("dblclick",{plot:this},this.onDblClick);this.eventCanvas._elem.bind("mousedown",{plot:this},this.onMouseDown);this.eventCanvas._elem.bind("mouseup",{plot:this},this.onMouseUp);this.eventCanvas._elem.bind("mousemove",{plot:this},this.onMouseMove);this.eventCanvas._elem.bind("mouseenter",{plot:this},this.onMouseEnter);this.eventCanvas._elem.bind("mouseleave",{plot:this},this.onMouseLeave)};function l(z){var y=z.data.plot;var u=y.eventCanvas._elem.offset();var x={x:z.pageX-u.left,y:z.pageY-u.top};var v={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null};var w=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var q=y.axes;for(var r=11;r>0;r--){var t=w[r-1];if(q[t].show){v[t]=q[t].series_p2u(x[t.charAt(0)])}}return({offsets:u,gridPos:x,dataPos:v})}function n(A,E,D){var B=null;var F,w,u,C,v,t;var z;for(var w=0;w<A.series.length;w++){F=A.series[w];t=F.renderer;if(F.show){z=Math.abs(F.markerRenderer.size/2+F.neighborThreshold);for(var v=0;v<F.gridData.length;v++){p=F.gridData[v];if(t.constructor==e.jqplot.OHLCRenderer){if(t.candleStick){var q=F._yaxis.series_u2p;if(E>=p[0]-t._bodyWidth/2&&E<=p[0]+t._bodyWidth/2&&D>=q(F.data[v][2])&&D<=q(F.data[v][3])){B={seriesIndex:w,pointIndex:v,gridData:p,data:F.data[v]}}}else{if(!t.hlc){var q=F._yaxis.series_u2p;if(E>=p[0]-t._tickLength&&E<=p[0]+t._tickLength&&D>=q(F.data[v][2])&&D<=q(F.data[v][3])){B={seriesIndex:w,pointIndex:v,gridData:p,data:F.data[v]}}}else{var q=F._yaxis.series_u2p;if(E>=p[0]-t._tickLength&&E<=p[0]+t._tickLength&&D>=q(F.data[v][1])&&D<=q(F.data[v][2])){B={seriesIndex:w,pointIndex:v,gridData:p,data:F.data[v]}}}}}else{C=Math.sqrt((E-p[0])*(E-p[0])+(D-p[1])*(D-p[1]));if(C<=z&&(C<=u||u==null)){u=C;B={seriesIndex:w,pointIndex:v,gridData:p,data:F.data[v]}}}}}}return B}this.onClick=function(r){var q=l(r);var u=r.data.plot;var t=n(u,q.gridPos.x,q.gridPos.y);r.data.plot.eventCanvas._elem.trigger("jqplotClick",[q.gridPos,q.dataPos,t,u])};this.onDblClick=function(r){var q=l(r);var u=r.data.plot;var t=n(u,q.gridPos.x,q.gridPos.y);r.data.plot.eventCanvas._elem.trigger("jqplotDblClick",[q.gridPos,q.dataPos,t,u])};this.onMouseDown=function(r){var q=l(r);var u=r.data.plot;var t=n(u,q.gridPos.x,q.gridPos.y);r.data.plot.eventCanvas._elem.trigger("jqplotMouseDown",[q.gridPos,q.dataPos,t,u])};this.onMouseUp=function(r){var q=l(r);r.data.plot.eventCanvas._elem.trigger("jqplotMouseUp",[q.gridPos,q.dataPos,null,r.data.plot])};this.onMouseMove=function(r){var q=l(r);var u=r.data.plot;var t=n(u,q.gridPos.x,q.gridPos.y);r.data.plot.eventCanvas._elem.trigger("jqplotMouseMove",[q.gridPos,q.dataPos,t,u])};this.onMouseEnter=function(r){var q=l(r);var t=r.data.plot;r.data.plot.eventCanvas._elem.trigger("jqplotMouseEnter",[q.gridPos,q.dataPos,null,t])};this.onMouseLeave=function(r){var q=l(r);var t=r.data.plot;r.data.plot.eventCanvas._elem.trigger("jqplotMouseLeave",[q.gridPos,q.dataPos,null,t])};this.drawSeries=function(t,q){t.clearRect(0,0,t.canvas.width,t.canvas.height);for(var r=0;r<this.series.length;r++){this.series[r].drawShadow(t,q)}for(var r=0;r<this.series.length;r++){this.series[r].draw(t,q)}}}e.jqplot.ColorGenerator=function(l){var k=0;this.next=function(){if(k<l.length){return l[k++]}else{k=0;return l[k++]}};this.previous=function(){if(k>0){return l[k--]}else{k=l.length-1;return l[k]}};this.get=function(n){return l[n]};this.setColors=function(n){l=n};this.reset=function(){k=0}};e.jqplot.hex2rgb=function(n,k){n=n.replace("#","");if(n.length==3){n=n[0]+n[0]+n[1]+n[1]+n[2]+n[2]}var l;l="rgba("+parseInt(n.slice(0,2),16)+", "+parseInt(n.slice(2,4),16)+", "+parseInt(n.slice(4,6),16);if(k){l+=", "+k}l+=")";return l};e.jqplot.rgb2hex=function(q){var n=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *(?:, *[0-9.]*)?\)/;var k=q.match(n);var o="#";for(i=1;i<4;i++){var l;if(k[i].search(/%/)!=-1){l=parseInt(255*k[i]/100,10).toString(16);if(l.length==1){l="0"+l}}else{l=parseInt(k[i],10).toString(16);if(l.length==1){l="0"+l}}o+=l}return o};e.jqplot.normalize2rgb=function(l,k){if(l.search(/^ *rgba?\(/)!=-1){return l}else{if(l.search(/^ *#?[0-9a-fA-F]?[0-9a-fA-F]/)!=-1){return e.jqplot.hex2rgb(l,k)}else{throw"invalid color spec"}}};e.jqplot.getColorComponents=function(q){var o=e.jqplot.normalize2rgb(q);var n=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *,? *([0-9.]* *)?\)/;var k=o.match(n);var l=[];for(i=1;i<4;i++){if(k[i].search(/%/)!=-1){l[i-1]=parseInt(255*k[i]/100,10)}else{l[i-1]=parseInt(k[i],10)}}l[3]=parseFloat(k[4])?parseFloat(k[4]):1;return l};e.jqplot.log=function(){if(window.console&&e.jqplot.debug){if(arguments.length==1){console.log(arguments[0])}else{console.log(arguments)}}};var c=e.jqplot.log;e.jqplot.AxisLabelRenderer=function(k){e.jqplot.ElemContainer.call(this);this.axis;this.show=true;this.label="";this._elem;this.escapeHTML=false;e.extend(true,this,k)};e.jqplot.AxisLabelRenderer.prototype=new e.jqplot.ElemContainer();e.jqplot.AxisLabelRenderer.prototype.constructor=e.jqplot.AxisLabelRenderer;e.jqplot.AxisLabelRenderer.prototype.init=function(k){e.extend(true,this,k)};e.jqplot.AxisLabelRenderer.prototype.draw=function(){this._elem=e('<div style="position:absolute;" class="jqplot-'+this.axis+'-label"></div>');if(Number(this.label)){this._elem.css("white-space","nowrap")}if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}return this._elem};e.jqplot.AxisLabelRenderer.prototype.pack=function(){};e.jqplot.AxisTickRenderer=function(k){e.jqplot.ElemContainer.call(this);this.mark="outside";this.axis;this.showMark=true;this.showGridline=true;this.isMinorTick=false;this.size=4;this.markSize=6;this.show=true;this.showLabel=true;this.label="";this.value=null;this._styles={};this.formatter=e.jqplot.DefaultTickFormatter;this.formatString="";this.fontFamily;this.fontSize;this.textColor;this._elem;e.extend(true,this,k)};e.jqplot.AxisTickRenderer.prototype.init=function(k){e.extend(true,this,k)};e.jqplot.AxisTickRenderer.prototype=new e.jqplot.ElemContainer();e.jqplot.AxisTickRenderer.prototype.constructor=e.jqplot.AxisTickRenderer;e.jqplot.AxisTickRenderer.prototype.setTick=function(k,n,l){this.value=k;this.axis=n;if(l){this.isMinorTick=true}return this};e.jqplot.AxisTickRenderer.prototype.draw=function(){if(!this.label){this.label=this.formatter(this.formatString,this.value)}style='style="position:absolute;';if(Number(this.label)){style+="white-space:nowrap;"}style+='"';this._elem=e("<div "+style+' class="jqplot-'+this.axis+'-tick">'+this.label+"</div>");for(var k in this._styles){this._elem.css(k,this._styles[k])}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}return this._elem};e.jqplot.DefaultTickFormatter=function(k,l){if(typeof l=="number"){if(!k){k="%.1f"}return e.jqplot.sprintf(k,l)}else{return String(l)}};e.jqplot.AxisTickRenderer.prototype.pack=function(){};e.jqplot.CanvasGridRenderer=function(){this.shadowRenderer=new e.jqplot.ShadowRenderer()};e.jqplot.CanvasGridRenderer.prototype.init=function(l){this._ctx;e.extend(true,this,l);var k={lineJoin:"miter",lineCap:"round",fill:false,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.shadowWidth,closePath:false};this.renderer.shadowRenderer.init(k)};e.jqplot.CanvasGridRenderer.prototype.createElement=function(){var n=document.createElement("canvas");var k=this._plotDimensions.width;var l=this._plotDimensions.height;n.width=k;n.height=l;this._elem=e(n);this._elem.addClass("jqplot-grid-canvas");this._elem.css({position:"absolute",left:0,top:0});if(e.browser.msie){window.G_vmlCanvasManager.init_(document)}if(e.browser.msie){n=window.G_vmlCanvasManager.initElement(n)}this._top=this._offsets.top;this._bottom=l-this._offsets.bottom;this._left=this._offsets.left;this._right=k-this._offsets.right;this._width=this._right-this._left;this._height=this._bottom-this._top;return this._elem};e.jqplot.CanvasGridRenderer.prototype.draw=function(){this._ctx=this._elem.get(0).getContext("2d");var E=this._ctx;var x=this._axes;E.save();E.fillStyle=this.background;E.fillRect(this._left,this._top,this._width,this._height);if(this.drawGridlines){E.save();E.lineJoin="miter";E.lineCap="butt";E.lineWidth=this.gridLineWidth;E.strokeStyle=this.gridLineColor;var z,w;var k=["xaxis","yaxis","x2axis","y2axis"];for(var r=4;r>0;r--){var l=k[r-1];var o=x[l];var A=o._ticks;if(o.show){for(var q=A.length;q>0;q--){var D=A[q-1];if(D.show){var y=Math.round(o.u2p(D.value))+0.5;switch(l){case"xaxis":if(D.showGridline){v(y,this._top,y,this._bottom)}if(D.showMark&&D.mark){s=D.markSize;m=D.mark;var y=Math.round(o.u2p(D.value))+0.5;switch(m){case"outside":z=this._bottom;w=this._bottom+s;break;case"inside":z=this._bottom-s;w=this._bottom;break;case"cross":z=this._bottom-s;w=this._bottom+s;break;default:z=this._bottom;w=this._bottom+s;break}if(this.shadow){this.renderer.shadowRenderer.draw(E,[[y,z],[y,w]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}v(y,z,y,w)}break;case"yaxis":if(D.showGridline){v(this._right,y,this._left,y)}if(D.showMark&&D.mark){s=D.markSize;m=D.mark;var y=Math.round(o.u2p(D.value))+0.5;switch(m){case"outside":z=this._left-s;w=this._left;break;case"inside":z=this._left;w=this._left+s;break;case"cross":z=this._left-s;w=this._left+s;break;default:z=this._left-s;w=this._left;break}if(this.shadow){this.renderer.shadowRenderer.draw(E,[[z,y],[w,y]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}v(z,y,w,y,{strokeStyle:o.borderColor})}break;case"x2axis":if(D.showGridline){v(y,this._bottom,y,this._top)}if(D.showMark&&D.mark){s=D.markSize;m=D.mark;var y=Math.round(o.u2p(D.value))+0.5;switch(m){case"outside":z=this._top-s;w=this._top;break;case"inside":z=this._top;w=this._top+s;break;case"cross":z=this._top-s;w=this._top+s;break;default:z=this._top-s;w=this._top;break}if(this.shadow){this.renderer.shadowRenderer.draw(E,[[y,z],[y,w]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}v(y,z,y,w)}break;case"y2axis":if(D.showGridline){v(this._left,y,this._right,y)}if(D.showMark&&D.mark){s=D.markSize;m=D.mark;var y=Math.round(o.u2p(D.value))+0.5;switch(m){case"outside":z=this._right;w=this._right+s;break;case"inside":z=this._right-s;w=this._right;break;case"cross":z=this._right-s;w=this._right+s;break;default:z=this._right;w=this._right+s;break}if(this.shadow){this.renderer.shadowRenderer.draw(E,[[z,y],[w,y]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}v(z,y,w,y,{strokeStyle:o.borderColor})}break;default:break}}}}}k=["y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];for(var r=7;r>0;r--){var o=x[k[r-1]];var A=o._ticks;if(o.show){var C=A[o.numberTicks-1];var u=A[0];var n=o.getLeft();var B=[[n,C.getTop()+C.getHeight()/2],[n,u.getTop()+u.getHeight()/2+1]];if(this.shadow){this.renderer.shadowRenderer.draw(E,B,{lineCap:"butt",fill:false,closePath:false})}v(B[0][0],B[0][1],B[1][0],B[1][1],{lineCap:"butt",strokeStyle:o.borderColor,lineWidth:o.borderWidth});for(var q=A.length;q>0;q--){var D=A[q-1];s=D.markSize;m=D.mark;var y=Math.round(o.u2p(D.value))+0.5;if(D.showMark&&D.mark){switch(m){case"outside":z=n;w=n+s;break;case"inside":z=n-s;w=n;break;case"cross":z=n-s;w=n+s;break;default:z=n;w=n+s;break}B=[[z,y],[w,y]];if(this.shadow){this.renderer.shadowRenderer.draw(E,B,{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}v(z,y,w,y,{strokeStyle:o.borderColor})}}}}E.restore()}function v(I,H,F,t,G){E.save();G=G||{};e.extend(true,E,G);E.beginPath();E.moveTo(I,H);E.lineTo(F,t);E.stroke();E.restore()}if(this.shadow){var B=[[this._left,this._bottom],[this._right,this._bottom],[this._right,this._top]];this.renderer.shadowRenderer.draw(E,B)}v(this._left,this._top,this._right,this._top,{lineCap:"round",strokeStyle:x.x2axis.borderColor,lineWidth:x.x2axis.borderWidth});v(this._right,this._top,this._right,this._bottom,{lineCap:"round",strokeStyle:x.y2axis.borderColor,lineWidth:x.y2axis.borderWidth});v(this._right,this._bottom,this._left,this._bottom,{lineCap:"round",strokeStyle:x.xaxis.borderColor,lineWidth:x.xaxis.borderWidth});v(this._left,this._bottom,this._left,this._top,{lineCap:"round",strokeStyle:x.yaxis.borderColor,lineWidth:x.yaxis.borderWidth});E.restore()};e.jqplot.DivTitleRenderer=function(){};e.jqplot.DivTitleRenderer.prototype.init=function(k){e.extend(true,this,k)};e.jqplot.DivTitleRenderer.prototype.draw=function(){var l=this.renderer;if(!this.text){this.show=false;this._elem=e('<div style="height:0px;width:0px;"></div>')}else{if(this.text){var k="position:absolute;top:0px;left:0px;";k+=(this._plotWidth)?"width:"+this._plotWidth+"px;":"";k+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";k+=(this.fontSize)?"font-size:"+this.fontSize+";":"";k+=(this.textAlign)?"text-align:"+this.textAlign+";":"text-align:center;";k+=(this.textColor)?"color:"+this.textColor+";":"";this._elem=e('<div class="jqplot-title" style="'+k+'">'+this.text+"</div>")}}return this._elem};e.jqplot.DivTitleRenderer.prototype.pack=function(){};e.jqplot.LineRenderer=function(){this.shapeRenderer=new e.jqplot.ShapeRenderer();this.shadowRenderer=new e.jqplot.ShadowRenderer()};e.jqplot.LineRenderer.prototype.init=function(l){e.extend(true,this.renderer,l);var o={lineJoin:"round",lineCap:"round",fill:this.fill,isarc:false,strokeStyle:this.color,fillStyle:this.fillColor,lineWidth:this.lineWidth,closePath:this.fill};this.renderer.shapeRenderer.init(o);if(this.lineWidth>2.5){var n=this.shadowOffset*(1+(Math.atan((this.lineWidth/2.5))/0.785398163-1)*0.6)}else{var n=this.shadowOffset*Math.atan((this.lineWidth/2.5))/0.785398163}var k={lineJoin:"round",lineCap:"round",fill:this.fill,isarc:false,angle:this.shadowAngle,offset:n,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.lineWidth,closePath:this.fill};this.renderer.shadowRenderer.init(k)};e.jqplot.LineRenderer.prototype.setGridData=function(){var l=this._xaxis.series_u2p;var q=this._yaxis.series_u2p;var n=this._plotData;var o=this._prevPlotData;this.gridData=[];this._prevGridData=[];for(var k=0;k<this.data.length;k++){if(n[k]!=null){this.gridData.push([l.call(this._xaxis,n[k][0]),q.call(this._yaxis,n[k][1])])}if(o[k]!=null){this._prevGridData.push([l.call(this._xaxis,o[k][0]),q.call(this._yaxis,o[k][1])])}}};e.jqplot.LineRenderer.prototype.makeGridData=function(o){var n=this._xaxis.series_u2p;var q=this._yaxis.series_u2p;var l=[];var r=[];for(var k=0;k<o.length;k++){if(o[k]!=null){l.push([n.call(this._xaxis,o[k][0]),q.call(this._yaxis,o[k][1])])}}return l};e.jqplot.LineRenderer.prototype.draw=function(y,F,l){var C;var w=(l!=b)?l:{};var o=(w.shadow!=b)?w.shadow:this.shadow;var H=(w.showLine!=b)?w.showLine:this.showLine;var B=(w.fill!=b)?w.fill:this.fill;var k=(w.fillAndStroke!=b)?w.fillAndStroke:this.fillAndStroke;y.save();if(F.length){if(H){if(B){if(this.fillToZero){var q=new e.jqplot.ColorGenerator(this.negativeSeriesColors);var D=q.get(this.index);var u=false;var v=w.fillStyle;if(k){var G=F.slice(0)}if(this.index==0||!this._stack){var z=[];var E=this._yaxis.series_u2p(0);var n=this._xaxis.series_u2p(0);if(this.fillAxis=="y"){z.push([F[0][0],E]);for(var C=0;C<F.length-1;C++){z.push(F[C]);if(this._plotData[C][1]*this._plotData[C+1][1]<0){if(this._plotData[C][1]<0){u=true;w.fillStyle=D}else{u=false;w.fillStyle=v}var t=F[C][0]+(F[C+1][0]-F[C][0])*(E-F[C][1])/(F[C+1][1]-F[C][1]);z.push([t,E]);if(o){this.renderer.shadowRenderer.draw(y,z,w)}this.renderer.shapeRenderer.draw(y,z,w);z=[[t,E]]}}if(this._plotData[F.length-1][1]<0){u=true;w.fillStyle=D}else{u=false;w.fillStyle=v}z.push(F[F.length-1]);z.push([F[F.length-1][0],E])}if(o){this.renderer.shadowRenderer.draw(y,z,w)}this.renderer.shapeRenderer.draw(y,z,w)}else{var x=this._prevGridData;for(var C=x.length;C>0;C--){F.push(x[C-1])}if(o){this.renderer.shadowRenderer.draw(y,F,w)}this.renderer.shapeRenderer.draw(y,F,w)}}else{if(k){var G=F.slice(0)}if(this.index==0||!this._stack){var r=y.canvas.height;F.unshift([F[0][0],r]);len=F.length;F.push([F[len-1][0],r])}else{var x=this._prevGridData;for(var C=x.length;C>0;C--){F.push(x[C-1])}}if(o){this.renderer.shadowRenderer.draw(y,F,w)}this.renderer.shapeRenderer.draw(y,F,w)}if(k){var A=e.extend(true,{},w,{fill:false,closePath:false});this.renderer.shapeRenderer.draw(y,G,A);if(this.markerRenderer.show){for(C=0;C<G.length;C++){this.markerRenderer.draw(G[C][0],G[C][1],y,w.markerOptions)}}}}else{if(o){this.renderer.shadowRenderer.draw(y,F,w)}this.renderer.shapeRenderer.draw(y,F,w)}}if(this.markerRenderer.show&&!B){for(C=0;C<F.length;C++){this.markerRenderer.draw(F[C][0],F[C][1],y,w.markerOptions)}}}y.restore()};e.jqplot.LineRenderer.prototype.drawShadow=function(k,n,l){};e.jqplot.LinearAxisRenderer=function(){};e.jqplot.LinearAxisRenderer.prototype.init=function(n){e.extend(true,this,n);var k=this._dataBounds;for(var o=0;o<this._series.length;o++){var q=this._series[o];var r=q._plotData;for(var l=0;l<r.length;l++){if(this.name=="xaxis"||this.name=="x2axis"){if(r[l][0]<k.min||k.min==null){k.min=r[l][0]}if(r[l][0]>k.max||k.max==null){k.max=r[l][0]}}else{if(r[l][1]<k.min||k.min==null){k.min=r[l][1]}if(r[l][1]>k.max||k.max==null){k.max=r[l][1]}}}}};e.jqplot.LinearAxisRenderer.prototype.draw=function(k){if(this.show){this.renderer.createTicks.call(this);var u=0;var l;this._elem=e('<div class="jqplot-axis jqplot-'+this.name+'" style="position:absolute;"></div>');if(this.name=="xaxis"||this.name=="x2axis"){this._elem.width(this._plotDimensions.width)}else{this._elem.height(this._plotDimensions.height)}this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);if(this._label.show){var r=this._label.draw(k);r.appendTo(this._elem)}if(this.showTicks){var q=this._ticks;for(var o=0;o<q.length;o++){var n=q[o];if(n.showLabel&&(!n.isMinorTick||this.showMinorTicks)){var r=n.draw(k);r.appendTo(this._elem)}}}}return this._elem};e.jqplot.LinearAxisRenderer.prototype.reset=function(){this.min=this._min;this.max=this._max;this.tickInterval=this._tickInterval;this.numberTicks=this._numberTicks};e.jqplot.LinearAxisRenderer.prototype.set=function(){var v=0;var n;var l=0;var u=0;var k=(this._label==null)?false:this._label.show;if(this.show&&this.showTicks){var r=this._ticks;for(var q=0;q<r.length;q++){var o=r[q];if(o.showLabel&&(!o.isMinorTick||this.showMinorTicks)){if(this.name=="xaxis"||this.name=="x2axis"){n=o._elem.outerHeight(true)}else{n=o._elem.outerWidth(true)}if(n>v){v=n}}}if(k){l=this._label._elem.outerWidth(true);u=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){v=v+u;this._elem.css({height:v+"px",left:"0px",bottom:"0px"})}else{if(this.name=="x2axis"){v=v+u;this._elem.css({height:v+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){v=v+l;this._elem.css({width:v+"px",left:"0px",top:"0px"});if(k&&this._label.constructor==e.jqplot.AxisLabelRenderer){this._label._elem.css("width",l+"px")}}else{v=v+l;this._elem.css({width:v+"px",right:"0px",top:"0px"});if(k&&this._label.constructor==e.jqplot.AxisLabelRenderer){this._label._elem.css("width",l+"px")}}}}}};e.jqplot.LinearAxisRenderer.prototype.createTicks=function(){var U=this._ticks;var Q=this.ticks;var V=this.name;var T=this._dataBounds;var L,R;var I,M;var o,n;var k,N;if(Q.length){for(N=0;N<Q.length;N++){var w=Q[N];var z=new this.tickRenderer(this.tickOptions);if(w.constructor==Array){z.value=w[0];z.label=w[1];if(!this.showTicks){z.showLabel=false;z.showMark=false}else{if(!this.showTickMarks){z.showMark=false}}z.setTick(w[0],this.name);this._ticks.push(z)}else{z.value=w;if(!this.showTicks){z.showLabel=false;z.showMark=false}else{if(!this.showTickMarks){z.showMark=false}}z.setTick(w,this.name);this._ticks.push(z)}}this.numberTicks=Q.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.tickInterval=(this.max-this.min)/(this.numberTicks-1)}else{if(V=="xaxis"||V=="x2axis"){L=this._plotDimensions.width}else{L=this._plotDimensions.height}if(!this.autoscale&&this.min!=null&&this.max!=null&&this.numberTicks!=null){this.tickInterval=null}I=((this.min!=null)?this.min:T.min);M=((this.max!=null)?this.max:T.max);if(I==M){var x=0.05;if(I>0){x=Math.max(Math.log(I)/Math.LN10,0.05)}I-=x;M+=x}var D=M-I;var H,K;var P;if(this.autoscale&&this.min==null&&this.max==null){var C,q,E;var y=false;var G=false;var l={min:null,max:null,average:null,stddev:null};for(var N=0;N<this._series.length;N++){var B=this._series[N];var u=(B.fillAxis=="x")?B._xaxis.name:B._yaxis.name;if(this.name==u){var A=B._plotValues[B.fillAxis];var r=A[0];var v=A[0];for(var J=1;J<A.length;J++){if(A[J]<r){r=A[J]}else{if(A[J]>v){v=A[J]}}}var F=(v-r)/v;if(B.renderer.constructor==e.jqplot.BarRenderer){if(r>=0&&(B.fillToZero||F>0.1)){y=true}else{y=false;if(B.fill&&B.fillToZero&&r<0&&v>0){G=true}else{G=false}}}else{if(B.fill){if(r>=0&&(B.fillToZero||F>0.1)){y=true}else{if(r<0&&v>0&&B.fillToZero){y=false;G=true}else{y=false;G=false}}}else{if(r<0){y=false}}}}}if(y){this.numberTicks=2+Math.ceil((L-(this.tickSpacing-1))/this.tickSpacing);this.min=0;q=M/(this.numberTicks-1);P=Math.pow(10,Math.abs(Math.floor(Math.log(q)/Math.LN10)));if(q/P==parseInt(q/P,10)){q+=P}this.tickInterval=Math.ceil(q/P)*P;this.max=this.tickInterval*(this.numberTicks-1)}else{if(G){this.numberTicks=2+Math.ceil((L-(this.tickSpacing-1))/this.tickSpacing);var O=Math.ceil(Math.abs(I)/D*(this.numberTicks-1));var S=this.numberTicks-1-O;q=Math.max(Math.abs(I/O),Math.abs(M/S));P=Math.pow(10,Math.abs(Math.floor(Math.log(q)/Math.LN10)));this.tickInterval=Math.ceil(q/P)*P;this.max=this.tickInterval*S;this.min=-this.tickInterval*O}else{if(this.numberTicks==null){this.numberTicks=2+Math.ceil((L-(this.tickSpacing-1))/this.tickSpacing)}if(this.tickInterval==null){q=D/(this.numberTicks-1);if(q<1){P=Math.pow(10,Math.abs(Math.floor(Math.log(q)/Math.LN10)))}else{P=1}this.tickInterval=Math.ceil(q*P*this.pad)/P}C=this.tickInterval*(this.numberTicks-1);E=(C-D)/2;if(this.min==null){this.min=Math.floor(P*(I-E))/P}if(this.max==null){this.max=this.min+C}}}}else{H=(this.min!=null)?this.min:I-D*(this.padMin-1);K=(this.max!=null)?this.max:M+D*(this.padMax-1);this.min=H;this.max=K;D=this.max-this.min;if(this.numberTicks==null){if(this.tickInterval!=null){this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(L>100){this.numberTicks=parseInt(3+(L-100)/75,10)}else{this.numberTicks=2}}}if(this.tickInterval==null){this.tickInterval=D/(this.numberTicks-1)}}for(var N=0;N<this.numberTicks;N++){k=this.min+N*this.tickInterval;var z=new this.tickRenderer(this.tickOptions);if(!this.showTicks){z.showLabel=false;z.showMark=false}else{if(!this.showTickMarks){z.showMark=false}}z.setTick(k,this.name);this._ticks.push(z)}}};e.jqplot.LinearAxisRenderer.prototype.pack=function(y,q){var B=this._ticks;var z=this.max;var u=this.min;var o=q.max;var F=q.min;var v=(this._label==null)?false:this._label.show;for(var k in y){this._elem.css(k,y[k])}this._offsets=q;var n=o-F;var E=z-u;this.p2u=function(t){return(t-F)*E/n+u};this.u2p=function(t){return(t-u)*n/E+F};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(t){return(t-u)*n/E};this.series_p2u=function(t){return t*E/n+u}}else{this.series_u2p=function(t){return(t-z)*n/E};this.series_p2u=function(t){return t*E/n+z}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(i=0;i<B.length;i++){var D=B[i];if(D.show&&D.showLabel){var r;if(D.constructor==e.jqplot.CanvasAxisTickRenderer&&D.angle){var C=(this.name=="xaxis")?1:-1;switch(D.labelPosition){case"auto":if(C*D.angle<0){r=-D.getWidth()+D._textRenderer.height*Math.sin(-D._textRenderer.angle)/2}else{r=-D._textRenderer.height*Math.sin(D._textRenderer.angle)/2}break;case"end":r=-D.getWidth()+D._textRenderer.height*Math.sin(-D._textRenderer.angle)/2;break;case"start":r=-D._textRenderer.height*Math.sin(D._textRenderer.angle)/2;break;case"middle":r=-D.getWidth()/2+D._textRenderer.height*Math.sin(-D._textRenderer.angle)/2;break;default:r=-D.getWidth()/2+D._textRenderer.height*Math.sin(-D._textRenderer.angle)/2;break}}else{r=-D.getWidth()/2}var l=this.u2p(D.value)+r+"px";D._elem.css("left",l);D.pack()}}if(v){var A=this._label._elem.outerWidth(true);this._label._elem.css("left",F+n/2-A/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(i=0;i<B.length;i++){var D=B[i];if(D.show&&D.showLabel){var r;if(D.constructor==e.jqplot.CanvasAxisTickRenderer&&D.angle){var C=(this.name=="yaxis")?1:-1;switch(D.labelPosition){case"auto":case"end":if(C*D.angle<0){r=-D._textRenderer.height*Math.cos(-D._textRenderer.angle)/2}else{r=-D.getHeight()+D._textRenderer.height*Math.cos(D._textRenderer.angle)/2}break;case"start":if(D.angle>0){r=-D._textRenderer.height*Math.cos(-D._textRenderer.angle)/2}else{r=-D.getHeight()+D._textRenderer.height*Math.cos(D._textRenderer.angle)/2}break;case"middle":r=-D.getHeight()/2;break;default:r=-D.getHeight()/2;break}}else{r=-D.getHeight()/2}var l=this.u2p(D.value)+r+"px";D._elem.css("top",l);D.pack()}}if(v){var x=this._label._elem.outerHeight(true);this._label._elem.css("top",o-n/2-x/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}};e.jqplot.MarkerRenderer=function(k){this.show=true;this.style="filledCircle";this.lineWidth=2;this.size=9;this.color="#666666";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1;this.shadowDepth=3;this.shadowAlpha="0.07";this.shadowRenderer=new e.jqplot.ShadowRenderer();this.shapeRenderer=new e.jqplot.ShapeRenderer();e.extend(true,this,k)};e.jqplot.MarkerRenderer.prototype.init=function(k){e.extend(true,this,k);var n={angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,lineWidth:this.lineWidth,depth:this.shadowDepth,closePath:true};if(this.style.indexOf("filled")!=-1){n.fill=true}if(this.style.indexOf("ircle")!=-1){n.isarc=true;n.closePath=false}this.shadowRenderer.init(n);var l={fill:false,isarc:false,strokeStyle:this.color,fillStyle:this.color,lineWidth:this.lineWidth,closePath:true};if(this.style.indexOf("filled")!=-1){l.fill=true}if(this.style.indexOf("ircle")!=-1){l.isarc=true;l.closePath=false}this.shapeRenderer.init(l)};e.jqplot.MarkerRenderer.prototype.drawDiamond=function(n,l,r,q,u){var k=1.2;var v=this.size/2/k;var t=this.size/2*k;var o=[[n-v,l],[n,l+t],[n+v,l],[n,l-t]];if(this.shadow){this.shadowRenderer.draw(r,o)}this.shapeRenderer.draw(r,o,u);r.restore()};e.jqplot.MarkerRenderer.prototype.drawPlus=function(o,n,t,r,w){var l=1;var z=this.size/2*l;var u=this.size/2*l;var v=[[o,n-u],[o,n+u]];var q=[[o+z,n],[o-z,n]];var k=e.extend(true,{},this.options,{closePath:false});if(this.shadow){this.shadowRenderer.draw(t,v,{closePath:false});this.shadowRenderer.draw(t,q,{closePath:false})}this.shapeRenderer.draw(t,v,k);this.shapeRenderer.draw(t,q,k);t.restore()};e.jqplot.MarkerRenderer.prototype.drawX=function(o,n,t,r,w){var l=1;var z=this.size/2*l;var u=this.size/2*l;var k=e.extend(true,{},this.options,{closePath:false});var v=[[o-z,n-u],[o+z,n+u]];var q=[[o-z,n+u],[o+z,n-u]];if(this.shadow){this.shadowRenderer.draw(t,v,{closePath:false});this.shadowRenderer.draw(t,q,{closePath:false})}this.shapeRenderer.draw(t,v,k);this.shapeRenderer.draw(t,q,k);t.restore()};e.jqplot.MarkerRenderer.prototype.drawDash=function(n,l,r,q,u){var k=1;var v=this.size/2*k;var t=this.size/2*k;var o=[[n-v,l],[n+v,l]];if(this.shadow){this.shadowRenderer.draw(r,o)}this.shapeRenderer.draw(r,o,u);r.restore()};e.jqplot.MarkerRenderer.prototype.drawSquare=function(n,l,r,q,u){var k=1;var v=this.size/2/k;var t=this.size/2*k;var o=[[n-v,l-t],[n-v,l+t],[n+v,l+t],[n+v,l-t]];if(this.shadow){this.shadowRenderer.draw(r,o)}this.shapeRenderer.draw(r,o,u);r.restore()};e.jqplot.MarkerRenderer.prototype.drawCircle=function(l,u,o,t,q){var k=this.size/2;var n=2*Math.PI;var r=[l,u,k,0,n,true];if(this.shadow){this.shadowRenderer.draw(o,r)}this.shapeRenderer.draw(o,r,q);o.restore()};e.jqplot.MarkerRenderer.prototype.draw=function(k,o,l,n){n=n||{};switch(this.style){case"diamond":this.drawDiamond(k,o,l,false,n);break;case"filledDiamond":this.drawDiamond(k,o,l,true,n);break;case"circle":this.drawCircle(k,o,l,false,n);break;case"filledCircle":this.drawCircle(k,o,l,true,n);break;case"square":this.drawSquare(k,o,l,false,n);break;case"filledSquare":this.drawSquare(k,o,l,true,n);break;case"x":this.drawX(k,o,l,true,n);break;case"plus":this.drawPlus(k,o,l,true,n);break;case"dash":this.drawDash(k,o,l,true,n);break;default:this.drawDiamond(k,o,l,false,n);break}};e.jqplot.ShadowRenderer=function(k){this.angle=45;this.offset=1;this.alpha=0.07;this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.depth=3;this.isarc=false;e.extend(true,this,k)};e.jqplot.ShadowRenderer.prototype.init=function(k){e.extend(true,this,k)};e.jqplot.ShadowRenderer.prototype.draw=function(w,u,x){w.save();var k=(x!=null)?x:{};var v=(k.fill!=null)?k.fill:this.fill;var t=(k.closePath!=null)?k.closePath:this.closePath;var o=(k.offset!=null)?k.offset:this.offset;var l=(k.alpha!=null)?k.alpha:this.alpha;var r=(k.depth!=null)?k.depth:this.depth;w.lineWidth=(k.lineWidth!=null)?k.lineWidth:this.lineWidth;w.lineJoin=(k.lineJoin!=null)?k.lineJoin:this.lineJoin;w.lineCap=(k.lineCap!=null)?k.lineCap:this.lineCap;w.strokeStyle="rgba(0,0,0,"+l+")";w.fillStyle="rgba(0,0,0,"+l+")";for(var n=0;n<r;n++){w.translate(Math.cos(this.angle*Math.PI/180)*o,Math.sin(this.angle*Math.PI/180)*o);w.beginPath();if(this.isarc){w.arc(u[0],u[1],u[2],u[3],u[4],true)}else{w.moveTo(u[0][0],u[0][1]);for(var q=1;q<u.length;q++){w.lineTo(u[q][0],u[q][1])}}if(t){w.closePath()}if(v){w.fill()}else{w.stroke()}}w.restore()};e.jqplot.ShapeRenderer=function(k){this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.isarc=false;this.fillRect=false;this.strokeRect=false;this.clearRect=false;this.strokeStyle="#999999";this.fillStyle="#999999";e.extend(true,this,k)};e.jqplot.ShapeRenderer.prototype.init=function(k){e.extend(true,this,k)};e.jqplot.ShapeRenderer.prototype.draw=function(v,t,x){v.save();var k=(x!=null)?x:{};var u=(k.fill!=null)?k.fill:this.fill;var q=(k.closePath!=null)?k.closePath:this.closePath;var r=(k.fillRect!=null)?k.fillRect:this.fillRect;var n=(k.strokeRect!=null)?k.strokeRect:this.strokeRect;var l=(k.clearRect!=null)?k.clearRect:this.clearRect;var w=(k.isarc!=null)?k.isarc:this.isarc;v.lineWidth=k.lineWidth||this.lineWidth;v.lineJoin=k.lineJoing||this.lineJoin;v.lineCap=k.lineCap||this.lineCap;v.strokeStyle=(k.strokeStyle||k.color)||this.strokeStyle;v.fillStyle=k.fillStyle||this.fillStyle;v.beginPath();if(w){v.arc(t[0],t[1],t[2],t[3],t[4],true);if(q){v.closePath()}if(u){v.fill()}else{v.stroke()}}else{if(r){v.fillRect(t[0],t[1],t[2],t[3])}else{if(n){v.strokeRect(t[0],t[1],t[2],t[3])}else{if(l){v.clearRect(t[0],t[1],t[2],t[3])}else{v.moveTo(t[0][0],t[0][1]);for(var o=1;o<t.length;o++){v.lineTo(t[o][0],t[o][1])}if(q){v.closePath()}if(u){v.fill()}else{v.stroke()}}}}}v.restore()};e.jqplot.TableLegendRenderer.prototype.init=function(k){e.extend(true,this,k)};e.jqplot.TableLegendRenderer.prototype.draw=function(){var t=this;if(this.show){var q=this._series;var w="position:absolute;";w+=(this.background)?"background:"+this.background+";":"";w+=(this.border)?"border:"+this.border+";":"";w+=(this.fontSize)?"font-size:"+this.fontSize+";":"";w+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";w+=(this.textColor)?"color:"+this.textColor+";":"";this._elem=e('<table class="jqplot-table-legend" style="'+w+'"></table>');var k=false;for(var r=0;r<q.length;r++){s=q[r];if(s.show&&s.showLabel){var o=s.label.toString();if(o){var l=s.color;if(s._stack&&!s.fill){l=""}v.call(this,o,l,k);k=true}for(var n=0;n<e.jqplot.addLegendRowHooks.length;n++){var u=e.jqplot.addLegendRowHooks[n].call(this,s);if(u){v.call(this,u.label,u.color,k);k=true}}}}}function v(z,y,C){var x=(C)?this.rowSpacing:"0";var B=e('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem);e('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+x+';"><div><div class="jqplot-table-legend-swatch" style="border-color:'+y+';"></div></div></td>').appendTo(B);var A=e('<td class="jqplot-table-legend" style="padding-top:'+x+';"></td>');A.appendTo(B);if(this.escapeHtml){A.text(z)}else{A.html(z)}}return this._elem};e.jqplot.TableLegendRenderer.prototype.pack=function(o){if(this.show){var n={_top:o.top,_left:o.left,_right:o.right,_bottom:this._plotDimensions.height-o.bottom};switch(this.location){case"nw":var l=n._left+this.xoffset;var k=n._top+this.yoffset;this._elem.css("left",l);this._elem.css("top",k);break;case"n":var l=(o.left+(this._plotDimensions.width-o.right))/2-this.getWidth()/2;var k=n._top+this.yoffset;this._elem.css("left",l);this._elem.css("top",k);break;case"ne":var l=o.right+this.xoffset;var k=n._top+this.yoffset;this._elem.css({right:l,top:k});break;case"e":var l=o.right+this.xoffset;var k=(o.top+(this._plotDimensions.height-o.bottom))/2-this.getHeight()/2;this._elem.css({right:l,top:k});break;case"se":var l=o.right+this.xoffset;var k=o.bottom+this.yoffset;this._elem.css({right:l,bottom:k});break;case"s":var l=(o.left+(this._plotDimensions.width-o.right))/2-this.getWidth()/2;var k=o.bottom+this.yoffset;this._elem.css({left:l,bottom:k});break;case"sw":var l=n._left+this.xoffset;var k=o.bottom+this.yoffset;this._elem.css({left:l,bottom:k});break;case"w":var l=n._left+this.xoffset;var k=(o.top+(this._plotDimensions.height-o.bottom))/2-this.getHeight()/2;this._elem.css({left:l,top:k});break;default:var l=n._right-this.xoffset;var k=n._bottom+this.yoffset;this._elem.css({right:l,bottom:k});break}}};e.jqplot.sprintf=function(){function r(y,u,v,x){var w=(y.length>=u)?"":Array(1+u-y.length>>>0).join(v);return x?y+w:w+y}function n(z,y,B,w,x,v){var A=w-z.length;if(A>0){var u=" ";if(v){u="&nbsp;"}if(B||!x){z=r(z,w,u,B)}else{z=z.slice(0,y.length)+r("",A,"0",true)+z.slice(y.length)}}return z}function t(C,v,A,w,u,z,B,y){var x=C>>>0;A=A&&x&&{"2":"0b","8":"0","16":"0x"}[v]||"";C=A+r(x.toString(v),z||0,"0",false);return n(C,A,w,u,B,y)}function k(y,z,w,u,x,v){if(u!=null){y=y.slice(0,u)}return n(y,"",z,w,x,v)}var l=arguments,o=0,q=l[o++];return q.replace(e.jqplot.sprintf.regex,function(N,A,B,E,P,L,y){if(N=="%%"){return"%"}var F=false,C="",D=false,M=false,z=false;for(var K=0;B&&K<B.length;K++){switch(B.charAt(K)){case" ":C=" ";break;case"+":C="+";break;case"-":F=true;break;case"0":D=true;break;case"#":M=true;break;case"&":z=true;break}}if(!E){E=0}else{if(E=="*"){E=+l[o++]}else{if(E.charAt(0)=="*"){E=+l[E.slice(1,-1)]}else{E=+E}}}if(E<0){E=-E;F=true}if(!isFinite(E)){throw new Error("$.jqplot.sprintf: (minimum-)width must be finite")}if(!L){L="fFeE".indexOf(y)>-1?6:(y=="d")?0:void (0)}else{if(L=="*"){L=+l[o++]}else{if(L.charAt(0)=="*"){L=+l[L.slice(1,-1)]}else{L=+L}}}var H=A?l[A.slice(0,-1)]:l[o++];switch(y){case"s":if(H==null){return""}return k(String(H),F,E,L,D,z);case"c":return k(String.fromCharCode(+H),F,E,L,D,z);case"b":return t(H,2,M,F,E,L,D,z);case"o":return t(H,8,M,F,E,L,D,z);case"x":return t(H,16,M,F,E,L,D,z);case"X":return t(H,16,M,F,E,L,D,z).toUpperCase();case"u":return t(H,10,M,F,E,L,D,z);case"i":case"d":var w=parseInt(+H);if(isNaN(w)){return""}var J=w<0?"-":C;H=J+r(String(Math.abs(w)),L,"0",false);return n(H,J,F,E,D,z);case"e":case"E":case"f":case"F":case"g":case"G":var w=+H;if(isNaN(w)){return""}var J=w<0?"-":C;var x=["toExponential","toFixed","toPrecision"]["efg".indexOf(y.toLowerCase())];var O=["toString","toUpperCase"]["eEfFgG".indexOf(y)%2];H=J+Math.abs(w)[x](L);return n(H,J,F,E,D,z)[O]();case"p":case"P":var w=+H;if(isNaN(w)){return""}var J=w<0?"-":C;var G=String(Number(Math.abs(w)).toExponential()).split(/e|E/);var v=(G[0].indexOf(".")!=-1)?G[0].length-1:G[0].length;var I=(G[1]<0)?-G[1]-1:0;if(Math.abs(w)<1){if(v+I<=L){H=J+Math.abs(w).toPrecision(v)}else{if(v<=L-1){H=J+Math.abs(w).toExponential(v-1)}else{H=J+Math.abs(w).toExponential(L-1)}}}else{var u=(v<=L)?v:L;H=J+Math.abs(w).toPrecision(u)}var O=["toString","toUpperCase"]["pP".indexOf(y)%2];return n(H,J,F,E,D,z)[O]();case"n":return"";default:return N}})};e.jqplot.sprintf.regex=/%%|%(\d+\$)?([-+#0& ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([nAscboxXuidfegpEGP])/g})(jQuery);