﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    /// <summary>
    /// マイルストーン
    /// </summary>
    public class Milestone
    {
        /// <summary>
        /// マイルストーン属性
        /// </summary>
        class MilestoneAttributes
        {
            public const string NAME = "name";                  // マイルストーン名
            public const string DESCRIPTION = "description";    // 説明
            public const string DUE = "due";                    // 完了期限
            public const string COMPLETED = "completed";        // 完了日
        }

        /// <summary>
        /// 属性
        /// </summary>
        XmlRpcAttributes Attributes = new XmlRpcAttributes();

        /// <summary>
        /// マイルストーン名
        /// </summary>
        public string Name
        {
            get
            {
                return Attributes.Get<string>( MilestoneAttributes.NAME );
            }

            set
            {
                Attributes.Set( MilestoneAttributes.NAME, value );
            }
        }

        /// <summary>
        /// 説明
        /// </summary>
        public string Description
        {
            get
            {
                return Attributes.Get<string>( MilestoneAttributes.DESCRIPTION );
            }

            set
            {
                Attributes.Set( MilestoneAttributes.DESCRIPTION, value );
            }
        }

        /// <summary>
        /// 完了期限
        /// </summary>
        public DateTime Due
        {
            get
            {
                return Attributes.Get<DateTime>( MilestoneAttributes.DUE );
            }

            set
            {
                Attributes.Set( MilestoneAttributes.DUE, value );
            }
        }

        /// <summary>
        /// 完了日
        /// </summary>
        public DateTime Conmleted
        {
            get
            {
                return Attributes.Get<DateTime>( MilestoneAttributes.COMPLETED );
            }

            set
            {
                Attributes.Set( MilestoneAttributes.COMPLETED, value );
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Milestone()
        {
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="name">マイルストーン名称</param>
        public Milestone( string name )
        {
            Get( name );
        }

        /// <summary>
        /// マイルストーンの詳細情報を取得
        /// </summary>
        /// <param name="name">マイルストーン名称</param>
        public void Get( string name )
        {
            Attributes.value = Trac.Rpc.ticketMilestoneGet( name );
        }

        /// <summary>
        /// 新規マイルストーンの作成
        /// </summary>
        /// <returns></returns>
        public void Create()
        {
            int ret = Trac.Rpc.ticketMilestoneCreate( Name, Attributes.value );
            if ( ret != 0 ) {
                throw new Exception( "ticketMilestoneCreate" );
            }
        }

        /// <summary>
        /// マイルストーンの更新
        /// </summary>
        /// <returns>処理結果</returns>
        public void Update()
        {
            int ret = Trac.Rpc.ticketMilestoneUpdate( Name, Attributes.value );
            if ( ret != 0 ) {
                throw new Exception( "ticketMilestoneUpdate" );
            }
        }

        /// <summary>
        /// マイルストーンの削除
        /// </summary>
        /// <returns>結果</returns>
        public void Delete()
        {
            Delete( Name );
        }

        /// <summary>
        /// マイルストーンの削除
        /// </summary>
        /// <param name="Name">削除するマイルストーン名称</param>
        /// <returns></returns>
        public static void Delete( string Name )
        {
            int ret = Trac.Rpc.ticketMilestoneDelete( Name );
            if ( ret != 0 ) {
                throw new Exception( "ticketMilestoneDelete" );
            }
        }

        /// <summary>
        /// マイルストーン名称一覧を取得
        /// </summary>
        /// <returns></returns>
        public static string[] GetAll()
        {
            return Trac.Rpc.ticketMilestoneGetAll();
        }
    }
}
