﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    /// <summary>
    /// XML-Trac.rpc システム APIs
    /// </summary>
    public class TracXmlRpcSystem
    {
        /// <summary>
        /// サポートするメソッドを取得
        /// </summary>
        /// <returns>メソッド名一覧</returns>
        public static string[] ListMethods()
        {
            return Trac.Rpc.systemListMethods();
        }

        /// <summary>
        /// メソッド名のヘルプを取得
        /// </summary>
        /// <param name="method">メソッド名</param>
        /// <returns>ヘルプ</returns>
        public static string GetMethodHelp( string method )
        {
            return Trac.Rpc.systemMethodHelp( method );
        }

        /// <summary>
        /// メソッドのシグニチャを取得
        /// </summary>
        /// <param name="method">メソッド名</param>
        /// <returns>シグニチャ</returns>
        public static string[] GetMethodSignature( string method )
        {
            return Trac.Rpc.systemMethodSignature( method );
        }

        /// <summary>
        /// APIバージョンの取得
        /// </summary>
        /// <returns></returns>
        public static string GetAPIVersion()
        {
            int[] versions = Trac.Rpc.systemGetAPIVersion();
            string version = "";
            foreach ( int v in versions ) {
                version += v + ".";
            }

            // 最後のピリオドを削除して返す
            return version.Remove( version.Length - 1 );
        }
    }
}
