﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// ITicketChangeListener インタフェースの生成
    /// </summary>
    public class TicketChangeListener : CodeGeneratorEnvironment, ICodeGenerator
    {
        public TicketChangeListener()
        {
        }

        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.ticket.api import ITicketChangeListener\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "ITicketChangeListener";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "ITicketChangeListener.py.template" );
        }
    }
}
