using System;
using System.Collections.Generic;
using System.Text;
using XmlRpcProxy;

namespace TracXmlRpc
{
    public class TicketProxy : ServiceProxy, ITicket
    {
        public TicketProxy()
        {
            this.MethodPrefix = "ticket";
        }

        public object[] Query()
        {
            return (object[])this.Invoke("query", new object[] { });
        }

        public object[] Query(string qstr)
        {
            return (object[])this.Invoke("query", new object[] { qstr });
        }

        public object[] GetRecentChanges(DateTime since)
        {
            return (object[])this.Invoke("getRecentChanges", new object[] { since });
        }

        public object[] GetAvailableActions(int id)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public object[] Get(int id)
        {
            return (object[])this.Invoke("get", new object[] { id });
        }

        public int Create(string summary, string description)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public int Create(string summary, string description, IDictionary<string, object> attributes)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public object[] Update(int id, string comment)
        {
            return (object[])this.Invoke("update", new object[] { id, comment });
        }

        public object[] Update(int id, string comment, IDictionary<string, object> attributes)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public int Delete(int id)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public IDictionary<string, object> ChangeLog(int id)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public IDictionary<string, object> ChangeLog(int id, int when)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public object[] ListAttachments(int ticket)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public byte[] GetAttachment(int ticket, string filename)
        {
            return (byte[])this.Invoke("getAttachment", new object[] { ticket, filename });
        }

        public string PutAttachment(int ticket, string filename, string description, byte[] data)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public string PutAttachment(int ticket, string filename, string description, byte[] data, bool replace)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public bool DeleteAttachment(int ticket, string filename)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public object[] GetTicketFields()
        {
            throw new Exception("The method or operation is not implemented.");
        }
    }
}
