# -*- encoding: utf-8 -*-
#   Copyright 2009 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Felix Schwarz <felix.schwarz__at__agile42.com>

from unittest import TestCase

from trac.ticket.api import TicketSystem

from agilo.test import TestEnvHelper
from agilo.ticket.api import AgiloTicketSystem

class AgiloTicketSystemTest(TestCase):
    
    def test_agiloticketsystem_returns_the_same_number_of_custom_fields_as_trac(self):
        # This uncovered a bug in AgiloConfig when the AgiloTicketSystem was not
        # notified about config changes so it kept outdated caches.
        env = TestEnvHelper().get_env()
        agilo_custom_fields = AgiloTicketSystem(env).get_custom_fields()
        trac_custom_fields = TicketSystem(env).get_custom_fields()
        self.assertEqual(len(agilo_custom_fields), len(trac_custom_fields))

