# -*- encoding: utf-8 -*-
#   Copyright 2008-2009 Agile42 GmbH, Berlin (Germany)
#   Copyright 2007 Andrea Tomasini <andrea.tomasini_at_agile42.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Jonas von Poser <jonas.vonposer__at__agile42.com>
#       - Felix Schwarz <felix.schwarz__at__agile42.com>

from trac.tests.functional import tc

from agilo.test import Usernames
from agilo.test.functional import AgiloTestCase


class TestAdminTypes(AgiloTestCase):
    
    def runTest(self):
        self._tester.login_as(Usernames.admin)
        # get page for editing requirement ticket type
        page_url = self._tester.url + '/admin/agilo/types/requirement'
        tc.go(page_url)
        tc.url(page_url)
        tc.code(200)
        tc.find('requirement')
        tc.find('Alias:')
        
        # test default field
        tc.find('name="fields" value="businessvalue" checked="checked"')
        
        # change alias and fields and save
        tc.formvalue('modcomp', 'fields', '+priority')
        tc.formvalue('modcomp', 'fields', '-businessvalue')
        tc.formvalue('modcomp', 'fields', '-milestone')
        tc.formvalue('modcomp', 'fields', '-keywords')
        tc.submit('save')
        
        # redirects to list page, now only the priority should be selected
        tc.find('<td class="fields">[\n ]*Priority<br />[\n ]*</td>')
        
        tc.go(page_url)
        # We must ensure that these fields are available for later tests.
        tc.formvalue('modcomp', 'fields', '+businessvalue')
        tc.formvalue('modcomp', 'fields', '+milestone')
        tc.submit('save')


class TestAdminCustomTypes(AgiloTestCase):
    """Adds a new ticket type through Trac and checks if it appears
        in the Agilo type admin page. Catches bug #264 as well."""
    def runTest(self):
        self._tester.login_as(Usernames.admin)
        type_name = 'Test_ticket_type'
        alias_name = 'MyALIAS'
        self._tester.create_new_ticket_type(type_name, alias=alias_name)
        # It's important that the ticket type is not all lower-cased so we can
        # see if the properties are really loaded again.
        url = self._tester.url + '/admin/agilo/types/%s' % type_name
        tc.go(url)
        tc.find(alias_name)
        
        tc.go(self._tester.url + '/admin/agilo/types')
        tc.find(alias_name)


if __name__ == '__main__':
    from agilo.test.testfinder import run_all_tests
    run_all_tests(__file__)

