# -*- coding: utf-8 -*-
"""
Created on 2010/08/07
@author: @tomosnowbug
"""
import unittest
from multirepositoryhelper.plugin import TicketUtil

class TicketUtilTest(unittest.TestCase):
    def setUp(self):
        self.extractor = TicketUtil()
        pass

    def tearDown(self):
        pass

    def testNewClass(self):
        self.assertNotEqual(TicketUtil(), None)
        
    def test_get_ticket_expresson(self):
        self.assertEqual(self.extractor.get_ticket_expresson("my project", 1),
                         "#my project/1")
        
    def test_create_link(self):
        absolute_url = "http://example.com/trac"
        tuple_proj_ticket_id = [("proj", "10")]
        self.assertEqual(self.extractor.create_link(
                            absolute_url, tuple_proj_ticket_id).generate().render(),
                         "<span>refs </span><a href=\"http://example.com/trac/proj/ticket/10\">#proj/10</a>")

    def test_extract_ticket_ids(self):
        self.assertEquals([], self.extractor.extract_ticket_ids("update test from unit test"))
        self.assertEquals(
                          [('proj1', '1')],
                           self.extractor.extract_ticket_ids(
                                "refs #proj1/1 refs proj1:#1 ,refs #2"))
        self.assertEquals(
                          [('proj1', '1'), ('proj2', '10'), ('proj3', '20')],
                           self.extractor.extract_ticket_ids(
                                "refs #proj1/1 refs #proj2/10  refs #proj3/20"))
        self.assertEquals(
                          [('proj1', '1')],
                           self.extractor.extract_ticket_ids(
                                "refs #proj1/1 ,#proj1/1 ,#proj2/2"))
        self.assertEquals(
                          [('proj1', '1')],
                           self.extractor.extract_ticket_ids(
                                "refs #proj1/1 \n#proj1/1 \n#proj2/2"))
        self.assertEquals(
                          [('p r o j 1', '1')],
                           self.extractor.extract_ticket_ids(
                                "refs #p r o j 1/1 ,#proj1/1 ,#proj2/2"))
        



if __name__ == '__main__':
    unittest.main()

