from trac.core import *
from trac.perm import IPermissionRequestor
from trac.web.chrome import INavigationContributor
from genshi.builder import tag
from trac.util.translation import _
from trac.util import Markup

class TraMPlugin(Component):
    """A plugin for integrating Trac with Tram for multi-project"""
    implements(INavigationContributor, IPermissionRequestor)

    # INavigationContributor methods
    def get_active_navigation_item(self, req):
        return 'projects'
    def get_navigation_items(self, req):
        yield ('mainnav', 'projects', tag.a(_('Project List'), href=req.href("../all/")))

    # IPermissionRequestor methods

    def get_permission_actions(self):
        return ['PROJECT_ACCESS']
