from setuptools import find_packages, setup

extra = {}

try:
    import babel
    extra['message_extractors'] = {
        'ganttcalendar': [
            ('**.py',                'python', None),
            ('**/templates/**.html', 'genshi', None),
            ('**/templates/**.txt',  'genshi', {
                'template_class': 'genshi.template:TextTemplate'
            })
        ],
    }
except ImportError:
    pass


setup(
    name='TracGanttCalendarPlugin', version='0.2',
    packages=find_packages(exclude=['*.tests*']),

    author = "Takashi Okamoto",
    author_email='okamototk@user.sourceforge.jp',
    url="http://sourceforge.jp/projects/shibuya-trac/",
    description='Provide calendar and ganttchart.',
    license = "New BSD",

    entry_points = """
        [trac.plugins]
        ganttcalendar.ticketcalendar = ganttcalendar.ticketcalendar
        ganttcalendar.ticketgantt = ganttcalendar.ticketgantt
        ganttcalendar.admin = ganttcalendar.admin
    """,
    package_data={'ganttcalendar': ['templates/*.html','htdocs/img/*','locale/*/*/*']},

    **extra
)

#        ticketcalendar = ticketcalendar