from setuptools import find_packages, setup
from trac.util.dist import get_l10n_cmdclass 

PACKAGE = 'tracsteinschart'


extra = {} 
cmdclass = get_l10n_cmdclass() 

if True:
    extra['cmdclass'] = cmdclass 
    extractors = [ 
       ('**.py',                'python', None), 
       ('**/templates/**.html', 'genshi', None), 
       ('**/templates/**.txt',  'genshi', { 
            'template_class': 'genshi.template:TextTemplate' 
       }), 
    ] 
    extra['message_extractors'] = { 
       PACKAGE: extractors, 
    }


setup(name='TracSteinsChart',
      description='Plugin to make Trac support time estimation and tracking',
      keywords='trac plugin estimation timetracking',
      version='0.1.9',
      url='http://sourceforge.jp/projects/shibuya-trac/wiki/plugins/TracSteinsChartPlugin',
      license='Apache Software License 2.0',
      author='Takashi Okamoto',
      author_email='toraneko at gmail.com',
      long_description="""
      Support scrum burndown char.

      See http://sourceforge.jp/projects/shibuya-trac/wiki/plugins/TracSteinsChartPlugin
      """,
      packages=find_packages(exclude=['*.tests*']),
      package_data={
          '': ['**/templates/*', '**/*.py'],
          'tracsteinschart' : ['htdocs/js/*.js', 'htdocs/js/plugins/*.js', 'htdocs/css/*.css', 'htdocs/images/*', 'locale/**/*.mo', 'locale/*.pot']
      },
      entry_points={'trac.plugins': [
              'tracsteinschart.chart = tracsteinschart.chart',
              'tracsteinschart.worktime = tracsteinschart.worktime',
          ],
      },
      **extra
)
