﻿using System;
using System.Collections.Generic;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    // 使うときはこうやって使ってください
    using TicketType = TracNameAndValueField<ITicketType>;

    /// <summary>
    /// チケットの分類 I/F
    /// </summary>
    public interface ITicketType : ITracNameAndValueField
    {
        /// <summary>
        /// チケット分類の一覧を取得する
        /// </summary>
        /// <returns>チケット分類の一覧</returns>
        [XmlRpcMethod( "ticket.type.getAll" )]
        new string[] GetAll();

        /// <summary>
        /// チケット分類を取得する
        /// </summary>
        /// <param name="name">チケット分類名称</param>
        /// <returns>チケット分類の順序</returns>
        [XmlRpcMethod( "ticket.type.get" )]
        new string Get( string name );

        /// <summary>
        /// チケット分類を削除する
        /// </summary>
        /// <param name="name">チケット分類名称</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.type.delete" )]
        new int Delete( string name );

        /// <summary>
        /// チケット分類を作成する
        /// </summary>
        /// <param name="name">チケット分類名称</param>
        /// <param name="value">チケット分類の順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.type.create" )]
        new int Create( string name, string value );

        /// <summary>
        /// チケット分類の更新
        /// </summary>
        /// <param name="name">更新するチケット分類名称</param>
        /// <param name="value">チケット分類の順序</param>
        /// <returns>処理結果</returns>
        /// <note>
        /// 分類名称自体は変更できない？？
        /// </note>
        [XmlRpcMethod( "ticket.type.update" )]
        new int Update( string name, string value );
    }
}
