﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;

namespace TracPluginTemplateMaker
{
    /// <summary>
    /// 開発者情報
    /// </summary>
    public class PluginInfo
    {
        // ファイル名
        private readonly string fileName = "";

        /// <summary>
        /// 開発者名
        /// </summary>
        public string Author
        {
            get;
            set;
        }

        //開発者メールアドレス
        public string Email
        {
            get;
            set;
        }

        /// <summary>
        /// プラグインURL
        /// </summary>
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// プラグインのライセンス
        /// </summary>
        public string License
        {
            get;
            set;
        }

        /// <summary>
        /// プラグインバージョン
        /// </summary>
        public string Version
        {
            get;
            set;
        }

        /// <summary>
        /// プラグイン詳細
        /// </summary>
        public string Description
        {
            set;
            get;
        }

        /// <summary>
        /// テンプレート出力フォルダ
        /// </summary>
        public string OutputDirectory
        {
            get;
            set;
        }

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public PluginInfo()
        {
            if ( string.IsNullOrEmpty( fileName ) ) {
                fileName =  Path.GetDirectoryName( Application.ExecutablePath ) + "\\PluginInfo.xml";
            }

            // 設定を保存する項目
            Author = "author name";
            Email = "info@example.com";
            Url = "http://example.com";
            License = "BSD";
            Version = "1.0";
            OutputDirectory = Environment.GetFolderPath( Environment.SpecialFolder.Desktop );

            // 設定を保存しない項目
            Description = "このプラグインの説明";

            // 設定値の復元
            if ( File.Exists( fileName ) ) {
                Load();
            }
        }

        /// <summary>
        /// デストラクタ
        /// </summary>
        ~PluginInfo()
        {
            Save();
        }

        /// <summary>
        /// XMLタグ
        /// </summary>
        internal class XML_TAG
        {
            public const string ROOT = "root";

            public const string Author = "Author";
            public const string Email = "Email";
            public const string Url = "Url";
            public const string License = "License";
            public const string Version = "Version";
            public const string OutputDirectory = "OutputDirectory";
        }

        private void Save()
        {
            // XML として保存
            XmlDocument xml = new XmlDocument();
            xml.AppendChild( xml.CreateXmlDeclaration( "1.0", "utf-8", null ) );

            XmlNode root = xml.CreateElement( XML_TAG.ROOT );

            // 設定値を保存
            XmlHelper.AppendChild( xml, root, XML_TAG.Author, Author );
            XmlHelper.AppendChild( xml, root, XML_TAG.Email, Email );
            XmlHelper.AppendChild( xml, root, XML_TAG.Url, Url );
            XmlHelper.AppendChild( xml, root, XML_TAG.License, License );
            XmlHelper.AppendChild( xml, root, XML_TAG.Version, Version );
            XmlHelper.AppendChild( xml, root, XML_TAG.OutputDirectory, OutputDirectory );

            xml.AppendChild( root );

            // 保存
            xml.Save( fileName );
        }

        private void Load()
        {
            // XML から復元
            XmlDocument xml = new XmlDocument();
            xml.Load( fileName );

            Author = xml.SelectNodes( "//" + XML_TAG.Author )[0].InnerText;
            Email = xml.SelectNodes( "//" + XML_TAG.Email )[0].InnerText;
            Url = xml.SelectNodes( "//" + XML_TAG.Url )[0].InnerText;
            License = xml.SelectNodes( "//" + XML_TAG.License )[0].InnerText;
            Version = xml.SelectNodes( "//" + XML_TAG.Version )[0].InnerText;
            OutputDirectory = xml.SelectNodes( "//" + XML_TAG.OutputDirectory )[0].InnerText;
        }
    }
}
