# -*- encoding: utf-8 -*-
#   Copyright 2009 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#   Authors: 
#       - Martin Häcker <martin.haecker_at_agile42.com>

from unittest import TestCase

from trac.web import Href
from trac.test import Mock

from agilo.test import TestEnvHelper

from agilo.utils.jquery_13_injector import JQuery13Injector, use_jquery_13

class JQuery13InjectorTest(TestCase):
    def setUp(self):
        teh = TestEnvHelper()
        self.env = teh.get_env()
        self.scripts = [{'href':'foo/jquery.js'}]
        self.req = Mock(chrome=dict(scripts=self.scripts), href=Href('/'))
    
    def set_scripts(self, scripts):
        for unused in range(len(self.scripts)):
            self.scripts.pop()
        self.scripts.extend(scripts)
    
    def test_injector_is_its_own_object(self):
        injector = JQuery13Injector()
        injector.inject(self.req)
        self.assertEquals(len(self.scripts), 1)
        self.assertEquals(self.scripts[0]['href'], '/chrome/agilo/js/jquery-1.3.2.min.js')
    
    def test_throws_exception_if_jquery_12_isnt_found_in_scripts_array(self):
        injector = JQuery13Injector()
        self.set_scripts([{'href':'bar/jquery-1.3.2.min.js'}])
        self.assertRaises(ValueError, injector.inject, self.req) # missing jquery 1.2
        
        self.set_scripts([])
        self.assertRaises(ValueError, injector.inject, self.req) # missing jquery 1.2
    
    def test_has_nice_interface_for_injector(self):
        use_jquery_13(self.req)
        self.assertEquals(len(self.scripts), 1)
        self.assertEquals(self.scripts[0]['href'], '/chrome/agilo/js/jquery-1.3.2.min.js')
