﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BTS.Trac;

namespace BTS.Trac.Forms.Helper
{
    /// <summary>
    /// フォーム関連ヘルパクラス
    /// </summary>
    public class Utility
    {
        /// <summary>
        /// Trac のサイトを表示
        /// </summary>
        /// <param name="page">表示するページ</param>
        public static void ShowTracSite( string page )
        {
            if ( !string.IsNullOrEmpty( Trac.Url ) ) {
                string url = Trac.Url;
                if ( url[url.Length - 1] != '/' ) {
                    url += "/";
                }
                Process.Start( url + page );
            }
        }

        /// <summary>
        /// 分を秒に直す
        /// </summary>
        /// <param name="minite"></param>
        /// <returns></returns>
        public static int MiniteToSecond( int minite )
        {
            return minite * 1000 * 60;
        }
    }
}
