﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    public class Authenticator : CodeGeneratorEnvironment, ICodeGenerator
    {
        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.web.api import IAuthenticator\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "IAuthenticator";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "IAuthenticator.py.template" );
        }
    }
}
