# -*- coding: utf-8 -*-
#
# http://trac.edgewall.org/wiki/TracDev/UnitTests
# http://pyunit.sourceforge.net/pyunit_ja.html


import unittest
#from tracblogrpc.xhtmltowiki import bodytowiki 

class WidgetTestCase(unittest.TestCase):

    def testHead(self):
        xhtml = \
"""<h1>hogea</h1>
<p>aaaa</p>
"""
        wiki = \
"""= hoge =

aaaa

"""
        ret =  xhtmltowiki2(xhtml)
        print>>sys.stderr, ret
        #assert ret == wiki, ret

    def testA(self):
        xhtml = \
"""<a class="wiki" href="/trac/wiki/WikiFormatting">WikiFormatting</a> is allowed.
"""
        wiki = \
"""= hoge =

aaaa

"""
        ret =  xhtmltowiki2(xhtml)
        print>>sys.stderr, ret
        #assert ret == wiki, ret

    def testFontStyle(self):
        xhtml = \
"""
<ul><li><strong>bold</strong>, <strong>''' can be bold too</strong>, and <strong>! </strong>
</li><li><i>italic</i>
</li><li><strong><i>bold italic</i></strong><strong>bold</strong>
</li><li><span class="underline">underline</span>
</li><li><tt>monospace</tt> or <tt>monospace</tt>
</li><li><del>strike-through</del>
</li><li><sup>superscript</sup> 
</li><li><sub>subscript</sub>
</li></ul>
"""
        wiki = \
"""
 * '''bold''', '''!''' can be bold too''', and '''! '''
 * ''italic''
 * '''''bold italic'''''
 * __underline__
 * {{{monospace}}} or `monospace`
 * ~~strike-through~~
 * ^superscript^ 
 * ,,subscript,,"""
        ret =  xhtmltowiki(xhtml)
        print>>sys.stderr, ret
        #assert ret == wiki, ret

    def testLists(self):
        xhtml = \
"""
<ul><li>Item 1
<ul><li>Item 1.1
</li></ul></li><li>Item 2
</li></ul><ol><li>Item 1
<ol class="loweralpha"><li>Item 1.a
</li><li>Item 1.b
<ol class="lowerroman"><li>Item 1.b.i
</li><li>Item 1.b.ii
</li></ol></li></ol></li><li>Item 2
</li></ol><p>
And numbered lists can also be given an explicit number:
</p>
<ol start="3"><li>Item 3
</li></ol>
"""
        wiki = \
"""
 * Item 1
   * Item 1.1
 * Item 2

 1. Item 1
   a. Item 1.a
   a. Item 1.b
      i. Item 1.b.i
      i. Item 1.b.ii
 1. Item 2
And numbered lists can also be given an explicit number:
 3. Item 3
"""
        ret =  xhtmltowiki2(xhtml)
        print>>sys.stderr, ret
        #assert ret == wiki, ret



def suite():
    suite = unittest.TestSuite()
    suite.addTest(WidgetTestCase("testHead"))
    suite.addTest(WidgetTestCase("testFontStyle"))
    suite.addTest(WidgetTestCase("testLists"))
    return suite

if __name__ == "__main__":
    unittest.main()