﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// コード生成環境基本クラス
    /// </summary>
    public class CodeGeneratorEnvironment
    {
        /// <summary>
        /// テンプレートファイル格納フォルダ
        /// </summary>
        public static string TemplateDirectory
        {
            get;
            set;
        }

        /// <summary>
        /// テンプレートファイルの読み込み
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static string ReadTemplateCode( string fileName )
        {
            using ( FileStream templateFile = File.Open( TemplateDirectory + "\\" + fileName, FileMode.Open ) ) {
                byte[] code = new byte[templateFile.Length];
                templateFile.Read( code, 0, code.Length );

                // UTF8 に変換して返す
                return Encoding.UTF8.GetString( code, 0, code.Length );
            }
        }
    }
}
