# -*- encoding: utf-8 -*-
#   Copyright 2008 Agile42 GmbH, Berlin (Germany)
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Authors: 
#       - Andrea Tomasini <andrea.tomasini__at__agile42.com>

import unittest
from datetime import datetime

from agilo.test import TestEnvHelper
from agilo.scrum.contingent import Contingent


class ContingentTest(unittest.TestCase):
    """Tests the contingent, in particulare the parameters which are not 
    standard in the PersistentObject"""
    def setUp(self):
        self.teh = TestEnvHelper()
        self.env = self.teh.get_env()
        self.team = self.teh.create_team('ContingentTeam')
        self.tm1 = self.teh.create_member('TM1', team=self.team)
        self.tm2 = self.teh.create_member('TM2', team=self.team)
        self.teh.disable_sprint_date_normalization()
        self.sprint = self.teh.create_sprint('ContingentSprint', 
                                             start=datetime(2009, 8, 10),
                                             duration=5, 
                                             team=self.team)
        
    def test_creation_with_percentage(self):
        """Tests the contingent creation with a percentage"""
        # the sprint is 5 days of duration with 2 members
        sprint_capacity = sum([self.tm1.get_total_hours_for_interval(self.sprint.start, self.sprint.end),
                               self.tm2.get_total_hours_for_interval(self.sprint.start, self.sprint.end)])
        self.assertEqual(60, sprint_capacity)
        percent = 10
        contingent = Contingent(self.env, name='BugFixingContingent', 
                                percent=percent, sprint=self.sprint)
        self.assertNotEqual(None, contingent)
        self.assertEqual(float(sprint_capacity)/100 * percent, contingent.amount)


if __name__ == '__main__':
    from agilo.test.testfinder import run_unit_tests
    run_unit_tests(__file__)
