﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// タイムラインを拡張
    /// </summary>
    public class TimelineEventProvider : CodeGeneratorEnvironment, ICodeGenerator
    {
        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.timeline import ITimelineEventProvider\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "ITimelineEventProvider";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode("ITimelineEventProvider.py.template");
        }
    }
}
